package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCabInstances invokes the cloudcallcenter.ListCabInstances API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcabinstances.html
func (client *Client) ListCabInstances(request *ListCabInstancesRequest) (response *ListCabInstancesResponse, err error) {
	response = CreateListCabInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCabInstancesWithChan invokes the cloudcallcenter.ListCabInstances API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcabinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListCabInstancesWithChan(request *ListCabInstancesRequest) (<-chan *ListCabInstancesResponse, <-chan error) {
	responseChan := make(chan *ListCabInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCabInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCabInstancesWithCallback invokes the cloudcallcenter.ListCabInstances API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcabinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListCabInstancesWithCallback(request *ListCabInstancesRequest, callback func(response *ListCabInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCabInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListCabInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCabInstancesRequest is the request struct for api ListCabInstances
type ListCabInstancesRequest struct {
	*requests.RpcRequest
}

// ListCabInstancesResponse is the response struct for api ListCabInstances
type ListCabInstancesResponse struct {
	*responses.BaseResponse
	RequestId      string             `json:"RequestId" xml:"RequestId"`
	Success        bool               `json:"Success" xml:"Success"`
	Code           string             `json:"Code" xml:"Code"`
	Message        string             `json:"Message" xml:"Message"`
	HttpStatusCode int                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Instances      []AgentBotInstance `json:"Instances" xml:"Instances"`
}

// CreateListCabInstancesRequest creates a request to invoke ListCabInstances API
func CreateListCabInstancesRequest() (request *ListCabInstancesRequest) {
	request = &ListCabInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListCabInstances", "", "")
	request.Method = requests.POST
	return
}

// CreateListCabInstancesResponse creates a response to parse from ListCabInstances response
func CreateListCabInstancesResponse() (response *ListCabInstancesResponse) {
	response = &ListCabInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
