package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEventTypeConfigs invokes the cloudcallcenter.ListEventTypeConfigs API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listeventtypeconfigs.html
func (client *Client) ListEventTypeConfigs(request *ListEventTypeConfigsRequest) (response *ListEventTypeConfigsResponse, err error) {
	response = CreateListEventTypeConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEventTypeConfigsWithChan invokes the cloudcallcenter.ListEventTypeConfigs API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listeventtypeconfigs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEventTypeConfigsWithChan(request *ListEventTypeConfigsRequest) (<-chan *ListEventTypeConfigsResponse, <-chan error) {
	responseChan := make(chan *ListEventTypeConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEventTypeConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEventTypeConfigsWithCallback invokes the cloudcallcenter.ListEventTypeConfigs API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listeventtypeconfigs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEventTypeConfigsWithCallback(request *ListEventTypeConfigsRequest, callback func(response *ListEventTypeConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEventTypeConfigsResponse
		var err error
		defer close(result)
		response, err = client.ListEventTypeConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEventTypeConfigsRequest is the request struct for api ListEventTypeConfigs
type ListEventTypeConfigsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListEventTypeConfigsResponse is the response struct for api ListEventTypeConfigs
type ListEventTypeConfigsResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	Success        bool      `json:"Success" xml:"Success"`
	Code           string    `json:"Code" xml:"Code"`
	Message        string    `json:"Message" xml:"Message"`
	HttpStatusCode int       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	InstanceId     string    `json:"InstanceId" xml:"InstanceId"`
	RamId          string    `json:"RamId" xml:"RamId"`
	ProducerId     string    `json:"ProducerId" xml:"ProducerId"`
	Topic          string    `json:"Topic" xml:"Topic"`
	AccessPoint    string    `json:"AccessPoint" xml:"AccessPoint"`
	IsClose        bool      `json:"IsClose" xml:"IsClose"`
	EventList      EventList `json:"EventList" xml:"EventList"`
}

// CreateListEventTypeConfigsRequest creates a request to invoke ListEventTypeConfigs API
func CreateListEventTypeConfigsRequest() (request *ListEventTypeConfigsRequest) {
	request = &ListEventTypeConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListEventTypeConfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateListEventTypeConfigsResponse creates a response to parse from ListEventTypeConfigs response
func CreateListEventTypeConfigsResponse() (response *ListEventTypeConfigsResponse) {
	response = &ListEventTypeConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
