package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetProvider invokes the cloudcallcenter.SetProvider API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/setprovider.html
func (client *Client) SetProvider(request *SetProviderRequest) (response *SetProviderResponse, err error) {
	response = CreateSetProviderResponse()
	err = client.DoAction(request, response)
	return
}

// SetProviderWithChan invokes the cloudcallcenter.SetProvider API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/setprovider.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetProviderWithChan(request *SetProviderRequest) (<-chan *SetProviderResponse, <-chan error) {
	responseChan := make(chan *SetProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetProviderWithCallback invokes the cloudcallcenter.SetProvider API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/setprovider.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetProviderWithCallback(request *SetProviderRequest, callback func(response *SetProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetProviderResponse
		var err error
		defer close(result)
		response, err = client.SetProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetProviderRequest is the request struct for api SetProvider
type SetProviderRequest struct {
	*requests.RpcRequest
	Provider string `position:"Query" name:"Provider"`
}

// SetProviderResponse is the response struct for api SetProvider
type SetProviderResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Provider       string `json:"Provider" xml:"Provider"`
}

// CreateSetProviderRequest creates a request to invoke SetProvider API
func CreateSetProviderRequest() (request *SetProviderRequest) {
	request = &SetProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "SetProvider", "", "")
	request.Method = requests.POST
	return
}

// CreateSetProviderResponse creates a response to parse from SetProvider response
func CreateSetProviderResponse() (response *SetProviderResponse) {
	response = &SetProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
