package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyImageDithering invokes the cloudesl.ApplyImageDithering API synchronously
func (client *Client) ApplyImageDithering(request *ApplyImageDitheringRequest) (response *ApplyImageDitheringResponse, err error) {
	response = CreateApplyImageDitheringResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyImageDitheringWithChan invokes the cloudesl.ApplyImageDithering API asynchronously
func (client *Client) ApplyImageDitheringWithChan(request *ApplyImageDitheringRequest) (<-chan *ApplyImageDitheringResponse, <-chan error) {
	responseChan := make(chan *ApplyImageDitheringResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyImageDithering(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyImageDitheringWithCallback invokes the cloudesl.ApplyImageDithering API asynchronously
func (client *Client) ApplyImageDitheringWithCallback(request *ApplyImageDitheringRequest, callback func(response *ApplyImageDitheringResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyImageDitheringResponse
		var err error
		defer close(result)
		response, err = client.ApplyImageDithering(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyImageDitheringRequest is the request struct for api ApplyImageDithering
type ApplyImageDitheringRequest struct {
	*requests.RpcRequest
	ExtraParams string           `position:"Body" name:"ExtraParams"`
	Content     string           `position:"Body" name:"Content"`
	DeviceType  string           `position:"Body" name:"DeviceType"`
	Height      requests.Integer `position:"Body" name:"Height"`
	Width       requests.Integer `position:"Body" name:"Width"`
}

// ApplyImageDitheringResponse is the response struct for api ApplyImageDithering
type ApplyImageDitheringResponse struct {
	*responses.BaseResponse
	Content        string `json:"Content" xml:"Content"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateApplyImageDitheringRequest creates a request to invoke ApplyImageDithering API
func CreateApplyImageDitheringRequest() (request *ApplyImageDitheringRequest) {
	request = &ApplyImageDitheringRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "ApplyImageDithering", "", "")
	request.Method = requests.POST
	return
}

// CreateApplyImageDitheringResponse creates a response to parse from ApplyImageDithering response
func CreateApplyImageDitheringResponse() (response *ApplyImageDitheringResponse) {
	response = &ApplyImageDitheringResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
