package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateStore invokes the cloudesl.CreateStore API synchronously
func (client *Client) CreateStore(request *CreateStoreRequest) (response *CreateStoreResponse, err error) {
	response = CreateCreateStoreResponse()
	err = client.DoAction(request, response)
	return
}

// CreateStoreWithChan invokes the cloudesl.CreateStore API asynchronously
func (client *Client) CreateStoreWithChan(request *CreateStoreRequest) (<-chan *CreateStoreResponse, <-chan error) {
	responseChan := make(chan *CreateStoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateStore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateStoreWithCallback invokes the cloudesl.CreateStore API asynchronously
func (client *Client) CreateStoreWithCallback(request *CreateStoreRequest, callback func(response *CreateStoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateStoreResponse
		var err error
		defer close(result)
		response, err = client.CreateStore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateStoreRequest is the request struct for api CreateStore
type CreateStoreRequest struct {
	*requests.RpcRequest
	ExtraParams   string `position:"Body" name:"ExtraParams"`
	ClientToken   string `position:"Body" name:"ClientToken"`
	TimeZone      string `position:"Body" name:"TimeZone"`
	StoreName     string `position:"Body" name:"StoreName"`
	ParentId      string `position:"Body" name:"ParentId"`
	UserStoreCode string `position:"Body" name:"UserStoreCode"`
	Phone         string `position:"Body" name:"Phone"`
}

// CreateStoreResponse is the response struct for api CreateStore
type CreateStoreResponse struct {
	*responses.BaseResponse
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Message        string `json:"Message" xml:"Message"`
	StoreId        string `json:"StoreId" xml:"StoreId"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateCreateStoreRequest creates a request to invoke CreateStore API
func CreateCreateStoreRequest() (request *CreateStoreRequest) {
	request = &CreateStoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "CreateStore", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateStoreResponse creates a response to parse from CreateStore response
func CreateCreateStoreResponse() (response *CreateStoreResponse) {
	response = &CreateStoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
