package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryLayoutDetail invokes the cloudesl.QueryLayoutDetail API synchronously
func (client *Client) QueryLayoutDetail(request *QueryLayoutDetailRequest) (response *QueryLayoutDetailResponse, err error) {
	response = CreateQueryLayoutDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryLayoutDetailWithChan invokes the cloudesl.QueryLayoutDetail API asynchronously
func (client *Client) QueryLayoutDetailWithChan(request *QueryLayoutDetailRequest) (<-chan *QueryLayoutDetailResponse, <-chan error) {
	responseChan := make(chan *QueryLayoutDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryLayoutDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryLayoutDetailWithCallback invokes the cloudesl.QueryLayoutDetail API asynchronously
func (client *Client) QueryLayoutDetailWithCallback(request *QueryLayoutDetailRequest, callback func(response *QueryLayoutDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryLayoutDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryLayoutDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryLayoutDetailRequest is the request struct for api QueryLayoutDetail
type QueryLayoutDetailRequest struct {
	*requests.RpcRequest
	LayoutId requests.Integer `position:"Body" name:"LayoutId"`
}

// QueryLayoutDetailResponse is the response struct for api QueryLayoutDetail
type QueryLayoutDetailResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	Success          bool   `json:"Success" xml:"Success"`
	Message          string `json:"Message" xml:"Message"`
	ErrorCode        string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage     string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code             string `json:"Code" xml:"Code"`
	DynamicCode      string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage   string `json:"DynamicMessage" xml:"DynamicMessage"`
	LayoutId         int64  `json:"LayoutId" xml:"LayoutId"`
	LayoutName       string `json:"LayoutName" xml:"LayoutName"`
	Description      string `json:"Description" xml:"Description"`
	LayoutTemplateId int64  `json:"LayoutTemplateId" xml:"LayoutTemplateId"`
	EslModelId       string `json:"EslModelId" xml:"EslModelId"`
	TemplateVersion  string `json:"TemplateVersion" xml:"TemplateVersion"`
	BrandId          string `json:"BrandId" xml:"BrandId"`
}

// CreateQueryLayoutDetailRequest creates a request to invoke QueryLayoutDetail API
func CreateQueryLayoutDetailRequest() (request *QueryLayoutDetailRequest) {
	request = &QueryLayoutDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "QueryLayoutDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryLayoutDetailResponse creates a response to parse from QueryLayoutDetail response
func CreateQueryLayoutDetailResponse() (response *QueryLayoutDetailResponse) {
	response = &QueryLayoutDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
