package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateItemMaterial invokes the cloudesl.UpdateItemMaterial API synchronously
func (client *Client) UpdateItemMaterial(request *UpdateItemMaterialRequest) (response *UpdateItemMaterialResponse, err error) {
	response = CreateUpdateItemMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateItemMaterialWithChan invokes the cloudesl.UpdateItemMaterial API asynchronously
func (client *Client) UpdateItemMaterialWithChan(request *UpdateItemMaterialRequest) (<-chan *UpdateItemMaterialResponse, <-chan error) {
	responseChan := make(chan *UpdateItemMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateItemMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateItemMaterialWithCallback invokes the cloudesl.UpdateItemMaterial API asynchronously
func (client *Client) UpdateItemMaterialWithCallback(request *UpdateItemMaterialRequest, callback func(response *UpdateItemMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateItemMaterialResponse
		var err error
		defer close(result)
		response, err = client.UpdateItemMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateItemMaterialRequest is the request struct for api UpdateItemMaterial
type UpdateItemMaterialRequest struct {
	*requests.RpcRequest
	MaterialId       string `position:"Body" name:"MaterialId"`
	BarCode          string `position:"Body" name:"BarCode"`
	ItemName         string `position:"Body" name:"ItemName"`
	MaterialFeatureA string `position:"Body" name:"MaterialFeatureA"`
	MaterialFeatureB string `position:"Body" name:"MaterialFeatureB"`
	MaterialFeatureC string `position:"Body" name:"MaterialFeatureC"`
	MaterialFeatureD string `position:"Body" name:"MaterialFeatureD"`
}

// UpdateItemMaterialResponse is the response struct for api UpdateItemMaterial
type UpdateItemMaterialResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateUpdateItemMaterialRequest creates a request to invoke UpdateItemMaterial API
func CreateUpdateItemMaterialRequest() (request *UpdateItemMaterialRequest) {
	request = &UpdateItemMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "UpdateItemMaterial", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateItemMaterialResponse creates a response to parse from UpdateItemMaterial response
func CreateUpdateItemMaterialResponse() (response *UpdateItemMaterialResponse) {
	response = &UpdateItemMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
