package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopCamera invokes the cloudwf.ShopCamera API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopcamera.html
func (client *Client) ShopCamera(request *ShopCameraRequest) (response *ShopCameraResponse, err error) {
	response = CreateShopCameraResponse()
	err = client.DoAction(request, response)
	return
}

// ShopCameraWithChan invokes the cloudwf.ShopCamera API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopcamera.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopCameraWithChan(request *ShopCameraRequest) (<-chan *ShopCameraResponse, <-chan error) {
	responseChan := make(chan *ShopCameraResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopCamera(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopCameraWithCallback invokes the cloudwf.ShopCamera API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopcamera.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopCameraWithCallback(request *ShopCameraRequest, callback func(response *ShopCameraResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopCameraResponse
		var err error
		defer close(result)
		response, err = client.ShopCamera(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopCameraRequest is the request struct for api ShopCamera
type ShopCameraRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// ShopCameraResponse is the response struct for api ShopCamera
type ShopCameraResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopCameraRequest creates a request to invoke ShopCamera API
func CreateShopCameraRequest() (request *ShopCameraRequest) {
	request = &ShopCameraRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopCamera", "cloudwf", "openAPI")
	return
}

// CreateShopCameraResponse creates a response to parse from ShopCamera response
func CreateShopCameraResponse() (response *ShopCameraResponse) {
	response = &ShopCameraResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
