package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferProduceOwner invokes the companyreg.TransferProduceOwner API synchronously
func (client *Client) TransferProduceOwner(request *TransferProduceOwnerRequest) (response *TransferProduceOwnerResponse, err error) {
	response = CreateTransferProduceOwnerResponse()
	err = client.DoAction(request, response)
	return
}

// TransferProduceOwnerWithChan invokes the companyreg.TransferProduceOwner API asynchronously
func (client *Client) TransferProduceOwnerWithChan(request *TransferProduceOwnerRequest) (<-chan *TransferProduceOwnerResponse, <-chan error) {
	responseChan := make(chan *TransferProduceOwnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferProduceOwner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferProduceOwnerWithCallback invokes the companyreg.TransferProduceOwner API asynchronously
func (client *Client) TransferProduceOwnerWithCallback(request *TransferProduceOwnerRequest, callback func(response *TransferProduceOwnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferProduceOwnerResponse
		var err error
		defer close(result)
		response, err = client.TransferProduceOwner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferProduceOwnerRequest is the request struct for api TransferProduceOwner
type TransferProduceOwnerRequest struct {
	*requests.RpcRequest
	BizType  string           `position:"Query" name:"BizType"`
	BizId    string           `position:"Query" name:"BizId"`
	PersonId requests.Integer `position:"Query" name:"PersonId"`
	Remark   string           `position:"Query" name:"Remark"`
}

// TransferProduceOwnerResponse is the response struct for api TransferProduceOwner
type TransferProduceOwnerResponse struct {
	*responses.BaseResponse
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateTransferProduceOwnerRequest creates a request to invoke TransferProduceOwner API
func CreateTransferProduceOwnerRequest() (request *TransferProduceOwnerRequest) {
	request = &TransferProduceOwnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "TransferProduceOwner", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTransferProduceOwnerResponse creates a response to parse from TransferProduceOwner response
func CreateTransferProduceOwnerResponse() (response *TransferProduceOwnerResponse) {
	response = &TransferProduceOwnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
