package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDasSQLLogHotData invokes the das.GetDasSQLLogHotData API synchronously
func (client *Client) GetDasSQLLogHotData(request *GetDasSQLLogHotDataRequest) (response *GetDasSQLLogHotDataResponse, err error) {
	response = CreateGetDasSQLLogHotDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetDasSQLLogHotDataWithChan invokes the das.GetDasSQLLogHotData API asynchronously
func (client *Client) GetDasSQLLogHotDataWithChan(request *GetDasSQLLogHotDataRequest) (<-chan *GetDasSQLLogHotDataResponse, <-chan error) {
	responseChan := make(chan *GetDasSQLLogHotDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDasSQLLogHotData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDasSQLLogHotDataWithCallback invokes the das.GetDasSQLLogHotData API asynchronously
func (client *Client) GetDasSQLLogHotDataWithCallback(request *GetDasSQLLogHotDataRequest, callback func(response *GetDasSQLLogHotDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDasSQLLogHotDataResponse
		var err error
		defer close(result)
		response, err = client.GetDasSQLLogHotData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDasSQLLogHotDataRequest is the request struct for api GetDasSQLLogHotData
type GetDasSQLLogHotDataRequest struct {
	*requests.RpcRequest
	ConsoleContext     string           `position:"Query" name:"ConsoleContext"`
	InstanceId         string           `position:"Body" name:"InstanceId"`
	Start              requests.Integer `position:"Body" name:"Start"`
	End                requests.Integer `position:"Body" name:"End"`
	QueryKeyword       string           `position:"Body" name:"QueryKeyword"`
	AccountName        string           `position:"Body" name:"AccountName"`
	DBName             string           `position:"Body" name:"DBName"`
	HostAddress        string           `position:"Body" name:"HostAddress"`
	LogicalOperator    string           `position:"Body" name:"LogicalOperator"`
	MaxLatancy         requests.Integer `position:"Body" name:"MaxLatancy"`
	MaxScanRows        requests.Integer `position:"Body" name:"MaxScanRows"`
	MinLatancy         requests.Integer `position:"Body" name:"MinLatancy"`
	MinScanRows        requests.Integer `position:"Body" name:"MinScanRows"`
	SqlType            string           `position:"Body" name:"SqlType"`
	State              string           `position:"Body" name:"State"`
	ThreadID           string           `position:"Body" name:"ThreadID"`
	PageNumbers        requests.Integer `position:"Body" name:"PageNumbers"`
	MaxRecordsPerPage  requests.Integer `position:"Body" name:"MaxRecordsPerPage"`
	SortKey            string           `position:"Body" name:"SortKey"`
	SortMethod         string           `position:"Body" name:"SortMethod"`
	ChildDBInstanceIDs string           `position:"Body" name:"ChildDBInstanceIDs"`
	Role               string           `position:"Body" name:"Role"`
	TraceId            string           `position:"Body" name:"TraceId"`
	MinRows            requests.Integer `position:"Body" name:"MinRows"`
	MaxRows            requests.Integer `position:"Body" name:"MaxRows"`
	MinSpillCnt        requests.Integer `position:"Body" name:"MinSpillCnt"`
	MaxSpillCnt        requests.Integer `position:"Body" name:"MaxSpillCnt"`
	TransactionId      string           `position:"Body" name:"TransactionId"`
	Fail               string           `position:"Body" name:"Fail"`
}

// GetDasSQLLogHotDataResponse is the response struct for api GetDasSQLLogHotData
type GetDasSQLLogHotDataResponse struct {
	*responses.BaseResponse
}

// CreateGetDasSQLLogHotDataRequest creates a request to invoke GetDasSQLLogHotData API
func CreateGetDasSQLLogHotDataRequest() (request *GetDasSQLLogHotDataRequest) {
	request = &GetDasSQLLogHotDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetDasSQLLogHotData", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDasSQLLogHotDataResponse creates a response to parse from GetDasSQLLogHotData response
func CreateGetDasSQLLogHotDataResponse() (response *GetDasSQLLogHotDataResponse) {
	response = &GetDasSQLLogHotDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
