package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueryOptimizeShareUrl invokes the das.GetQueryOptimizeShareUrl API synchronously
func (client *Client) GetQueryOptimizeShareUrl(request *GetQueryOptimizeShareUrlRequest) (response *GetQueryOptimizeShareUrlResponse, err error) {
	response = CreateGetQueryOptimizeShareUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueryOptimizeShareUrlWithChan invokes the das.GetQueryOptimizeShareUrl API asynchronously
func (client *Client) GetQueryOptimizeShareUrlWithChan(request *GetQueryOptimizeShareUrlRequest) (<-chan *GetQueryOptimizeShareUrlResponse, <-chan error) {
	responseChan := make(chan *GetQueryOptimizeShareUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueryOptimizeShareUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueryOptimizeShareUrlWithCallback invokes the das.GetQueryOptimizeShareUrl API asynchronously
func (client *Client) GetQueryOptimizeShareUrlWithCallback(request *GetQueryOptimizeShareUrlRequest, callback func(response *GetQueryOptimizeShareUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueryOptimizeShareUrlResponse
		var err error
		defer close(result)
		response, err = client.GetQueryOptimizeShareUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueryOptimizeShareUrlRequest is the request struct for api GetQueryOptimizeShareUrl
type GetQueryOptimizeShareUrlRequest struct {
	*requests.RpcRequest
	ConsoleContext   string           `position:"Query" name:"ConsoleContext"`
	Engine           string           `position:"Query" name:"Engine"`
	InstanceIds      string           `position:"Query" name:"InstanceIds"`
	TagNames         string           `position:"Query" name:"TagNames"`
	Keywords         string           `position:"Query" name:"Keywords"`
	LogicalOperator  string           `position:"Query" name:"LogicalOperator"`
	Rules            string           `position:"Query" name:"Rules"`
	DbNames          string           `position:"Query" name:"DbNames"`
	Time             requests.Integer `position:"Query" name:"Time"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	PageNo           requests.Integer `position:"Query" name:"PageNo"`
	OrderBy          string           `position:"Query" name:"OrderBy"`
	Asc              requests.Boolean `position:"Query" name:"Asc"`
	OnlyOptimizedSql requests.Boolean `position:"Query" name:"OnlyOptimizedSql"`
	SqlIds           string           `position:"Query" name:"SqlIds"`
	Region           string           `position:"Query" name:"Region"`
	User             string           `position:"Query" name:"User"`
}

// GetQueryOptimizeShareUrlResponse is the response struct for api GetQueryOptimizeShareUrl
type GetQueryOptimizeShareUrlResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetQueryOptimizeShareUrlRequest creates a request to invoke GetQueryOptimizeShareUrl API
func CreateGetQueryOptimizeShareUrlRequest() (request *GetQueryOptimizeShareUrlRequest) {
	request = &GetQueryOptimizeShareUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetQueryOptimizeShareUrl", "", "")
	request.Method = requests.GET
	return
}

// CreateGetQueryOptimizeShareUrlResponse creates a response to parse from GetQueryOptimizeShareUrl response
func CreateGetQueryOptimizeShareUrlResponse() (response *GetQueryOptimizeShareUrlResponse) {
	response = &GetQueryOptimizeShareUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
