package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetEventSubscription invokes the das.SetEventSubscription API synchronously
func (client *Client) SetEventSubscription(request *SetEventSubscriptionRequest) (response *SetEventSubscriptionResponse, err error) {
	response = CreateSetEventSubscriptionResponse()
	err = client.DoAction(request, response)
	return
}

// SetEventSubscriptionWithChan invokes the das.SetEventSubscription API asynchronously
func (client *Client) SetEventSubscriptionWithChan(request *SetEventSubscriptionRequest) (<-chan *SetEventSubscriptionResponse, <-chan error) {
	responseChan := make(chan *SetEventSubscriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetEventSubscription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetEventSubscriptionWithCallback invokes the das.SetEventSubscription API asynchronously
func (client *Client) SetEventSubscriptionWithCallback(request *SetEventSubscriptionRequest, callback func(response *SetEventSubscriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetEventSubscriptionResponse
		var err error
		defer close(result)
		response, err = client.SetEventSubscription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetEventSubscriptionRequest is the request struct for api SetEventSubscription
type SetEventSubscriptionRequest struct {
	*requests.RpcRequest
	ContactGroupName string `position:"Query" name:"ContactGroupName"`
	ContactName      string `position:"Query" name:"ContactName"`
	DispatchRule     string `position:"Query" name:"DispatchRule"`
	ChannelType      string `position:"Query" name:"ChannelType"`
	Lang             string `position:"Query" name:"Lang"`
	Severity         string `position:"Query" name:"Severity"`
	Level            string `position:"Query" name:"Level"`
	Active           string `position:"Query" name:"Active"`
	MinInterval      string `position:"Query" name:"MinInterval"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	EventContext     string `position:"Query" name:"EventContext"`
}

// SetEventSubscriptionResponse is the response struct for api SetEventSubscription
type SetEventSubscriptionResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Message   string                     `json:"Message" xml:"Message"`
	Code      string                     `json:"Code" xml:"Code"`
	Success   string                     `json:"Success" xml:"Success"`
	Data      DataInSetEventSubscription `json:"Data" xml:"Data"`
}

// CreateSetEventSubscriptionRequest creates a request to invoke SetEventSubscription API
func CreateSetEventSubscriptionRequest() (request *SetEventSubscriptionRequest) {
	request = &SetEventSubscriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "SetEventSubscription", "", "")
	request.Method = requests.POST
	return
}

// CreateSetEventSubscriptionResponse creates a response to parse from SetEventSubscription response
func CreateSetEventSubscriptionResponse() (response *SetEventSubscriptionResponse) {
	response = &SetEventSubscriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
