package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopCloudBenchTask invokes the das.StopCloudBenchTask API synchronously
func (client *Client) StopCloudBenchTask(request *StopCloudBenchTaskRequest) (response *StopCloudBenchTaskResponse, err error) {
	response = CreateStopCloudBenchTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StopCloudBenchTaskWithChan invokes the das.StopCloudBenchTask API asynchronously
func (client *Client) StopCloudBenchTaskWithChan(request *StopCloudBenchTaskRequest) (<-chan *StopCloudBenchTaskResponse, <-chan error) {
	responseChan := make(chan *StopCloudBenchTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopCloudBenchTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopCloudBenchTaskWithCallback invokes the das.StopCloudBenchTask API asynchronously
func (client *Client) StopCloudBenchTaskWithCallback(request *StopCloudBenchTaskRequest, callback func(response *StopCloudBenchTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopCloudBenchTaskResponse
		var err error
		defer close(result)
		response, err = client.StopCloudBenchTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopCloudBenchTaskRequest is the request struct for api StopCloudBenchTask
type StopCloudBenchTaskRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Query" name:"TaskId"`
}

// StopCloudBenchTaskResponse is the response struct for api StopCloudBenchTask
type StopCloudBenchTaskResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateStopCloudBenchTaskRequest creates a request to invoke StopCloudBenchTask API
func CreateStopCloudBenchTaskRequest() (request *StopCloudBenchTaskRequest) {
	request = &StopCloudBenchTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "StopCloudBenchTask", "", "")
	request.Method = requests.POST
	return
}

// CreateStopCloudBenchTaskResponse creates a response to parse from StopCloudBenchTask response
func CreateStopCloudBenchTaskResponse() (response *StopCloudBenchTaskResponse) {
	response = &StopCloudBenchTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
