package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportDataSources invokes the dataworks_public.ExportDataSources API synchronously
func (client *Client) ExportDataSources(request *ExportDataSourcesRequest) (response *ExportDataSourcesResponse, err error) {
	response = CreateExportDataSourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ExportDataSourcesWithChan invokes the dataworks_public.ExportDataSources API asynchronously
func (client *Client) ExportDataSourcesWithChan(request *ExportDataSourcesRequest) (<-chan *ExportDataSourcesResponse, <-chan error) {
	responseChan := make(chan *ExportDataSourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportDataSources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportDataSourcesWithCallback invokes the dataworks_public.ExportDataSources API asynchronously
func (client *Client) ExportDataSourcesWithCallback(request *ExportDataSourcesRequest, callback func(response *ExportDataSourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportDataSourcesResponse
		var err error
		defer close(result)
		response, err = client.ExportDataSources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportDataSourcesRequest is the request struct for api ExportDataSources
type ExportDataSourcesRequest struct {
	*requests.RpcRequest
	DataSourceType string           `position:"Query" name:"DataSourceType"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	SubType        string           `position:"Query" name:"SubType"`
	Name           string           `position:"Query" name:"Name"`
	EnvType        requests.Integer `position:"Query" name:"EnvType"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
}

// ExportDataSourcesResponse is the response struct for api ExportDataSources
type ExportDataSourcesResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateExportDataSourcesRequest creates a request to invoke ExportDataSources API
func CreateExportDataSourcesRequest() (request *ExportDataSourcesRequest) {
	request = &ExportDataSourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ExportDataSources", "", "")
	request.Method = requests.GET
	return
}

// CreateExportDataSourcesResponse creates a response to parse from ExportDataSources response
func CreateExportDataSourcesResponse() (response *ExportDataSourcesResponse) {
	response = &ExportDataSourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
