package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBusiness invokes the dataworks_public.GetBusiness API synchronously
func (client *Client) GetBusiness(request *GetBusinessRequest) (response *GetBusinessResponse, err error) {
	response = CreateGetBusinessResponse()
	err = client.DoAction(request, response)
	return
}

// GetBusinessWithChan invokes the dataworks_public.GetBusiness API asynchronously
func (client *Client) GetBusinessWithChan(request *GetBusinessRequest) (<-chan *GetBusinessResponse, <-chan error) {
	responseChan := make(chan *GetBusinessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBusiness(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBusinessWithCallback invokes the dataworks_public.GetBusiness API asynchronously
func (client *Client) GetBusinessWithCallback(request *GetBusinessRequest, callback func(response *GetBusinessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBusinessResponse
		var err error
		defer close(result)
		response, err = client.GetBusiness(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBusinessRequest is the request struct for api GetBusiness
type GetBusinessRequest struct {
	*requests.RpcRequest
	BusinessId        requests.Integer `position:"Body" name:"BusinessId"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	ProjectIdentifier string           `position:"Body" name:"ProjectIdentifier"`
}

// GetBusinessResponse is the response struct for api GetBusiness
type GetBusinessResponse struct {
	*responses.BaseResponse
	HttpStatusCode int               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string            `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string            `json:"RequestId" xml:"RequestId"`
	ErrorCode      string            `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool              `json:"Success" xml:"Success"`
	Data           DataInGetBusiness `json:"Data" xml:"Data"`
}

// CreateGetBusinessRequest creates a request to invoke GetBusiness API
func CreateGetBusinessRequest() (request *GetBusinessRequest) {
	request = &GetBusinessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetBusiness", "", "")
	request.Method = requests.POST
	return
}

// CreateGetBusinessResponse creates a response to parse from GetBusiness response
func CreateGetBusinessResponse() (response *GetBusinessResponse) {
	response = &GetBusinessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
