package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataServiceApiTest invokes the dataworks_public.GetDataServiceApiTest API synchronously
func (client *Client) GetDataServiceApiTest(request *GetDataServiceApiTestRequest) (response *GetDataServiceApiTestResponse, err error) {
	response = CreateGetDataServiceApiTestResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataServiceApiTestWithChan invokes the dataworks_public.GetDataServiceApiTest API asynchronously
func (client *Client) GetDataServiceApiTestWithChan(request *GetDataServiceApiTestRequest) (<-chan *GetDataServiceApiTestResponse, <-chan error) {
	responseChan := make(chan *GetDataServiceApiTestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataServiceApiTest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataServiceApiTestWithCallback invokes the dataworks_public.GetDataServiceApiTest API asynchronously
func (client *Client) GetDataServiceApiTestWithCallback(request *GetDataServiceApiTestRequest, callback func(response *GetDataServiceApiTestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataServiceApiTestResponse
		var err error
		defer close(result)
		response, err = client.GetDataServiceApiTest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataServiceApiTestRequest is the request struct for api GetDataServiceApiTest
type GetDataServiceApiTestRequest struct {
	*requests.RpcRequest
	TestId requests.Integer `position:"Query" name:"TestId"`
}

// GetDataServiceApiTestResponse is the response struct for api GetDataServiceApiTest
type GetDataServiceApiTestResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDataServiceApiTestRequest creates a request to invoke GetDataServiceApiTest API
func CreateGetDataServiceApiTestRequest() (request *GetDataServiceApiTestRequest) {
	request = &GetDataServiceApiTestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetDataServiceApiTest", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDataServiceApiTestResponse creates a response to parse from GetDataServiceApiTest response
func CreateGetDataServiceApiTestResponse() (response *GetDataServiceApiTestResponse) {
	response = &GetDataServiceApiTestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
