package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnWafPolicy invokes the dcdn.DeleteDcdnWafPolicy API synchronously
func (client *Client) DeleteDcdnWafPolicy(request *DeleteDcdnWafPolicyRequest) (response *DeleteDcdnWafPolicyResponse, err error) {
	response = CreateDeleteDcdnWafPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnWafPolicyWithChan invokes the dcdn.DeleteDcdnWafPolicy API asynchronously
func (client *Client) DeleteDcdnWafPolicyWithChan(request *DeleteDcdnWafPolicyRequest) (<-chan *DeleteDcdnWafPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnWafPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnWafPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnWafPolicyWithCallback invokes the dcdn.DeleteDcdnWafPolicy API asynchronously
func (client *Client) DeleteDcdnWafPolicyWithCallback(request *DeleteDcdnWafPolicyRequest, callback func(response *DeleteDcdnWafPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnWafPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnWafPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnWafPolicyRequest is the request struct for api DeleteDcdnWafPolicy
type DeleteDcdnWafPolicyRequest struct {
	*requests.RpcRequest
	PolicyId requests.Integer `position:"Body" name:"PolicyId"`
}

// DeleteDcdnWafPolicyResponse is the response struct for api DeleteDcdnWafPolicy
type DeleteDcdnWafPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnWafPolicyRequest creates a request to invoke DeleteDcdnWafPolicy API
func CreateDeleteDcdnWafPolicyRequest() (request *DeleteDcdnWafPolicyRequest) {
	request = &DeleteDcdnWafPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnWafPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnWafPolicyResponse creates a response to parse from DeleteDcdnWafPolicy response
func CreateDeleteDcdnWafPolicyResponse() (response *DeleteDcdnWafPolicyResponse) {
	response = &DeleteDcdnWafPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
