package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnIpaUserDomains invokes the dcdn.DescribeDcdnIpaUserDomains API synchronously
func (client *Client) DescribeDcdnIpaUserDomains(request *DescribeDcdnIpaUserDomainsRequest) (response *DescribeDcdnIpaUserDomainsResponse, err error) {
	response = CreateDescribeDcdnIpaUserDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnIpaUserDomainsWithChan invokes the dcdn.DescribeDcdnIpaUserDomains API asynchronously
func (client *Client) DescribeDcdnIpaUserDomainsWithChan(request *DescribeDcdnIpaUserDomainsRequest) (<-chan *DescribeDcdnIpaUserDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnIpaUserDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnIpaUserDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnIpaUserDomainsWithCallback invokes the dcdn.DescribeDcdnIpaUserDomains API asynchronously
func (client *Client) DescribeDcdnIpaUserDomainsWithCallback(request *DescribeDcdnIpaUserDomainsRequest, callback func(response *DescribeDcdnIpaUserDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnIpaUserDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnIpaUserDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnIpaUserDomainsRequest is the request struct for api DescribeDcdnIpaUserDomains
type DescribeDcdnIpaUserDomainsRequest struct {
	*requests.RpcRequest
	PageNumber       requests.Integer                 `position:"Query" name:"PageNumber"`
	CheckDomainShow  requests.Boolean                 `position:"Query" name:"CheckDomainShow"`
	ResourceGroupId  string                           `position:"Query" name:"ResourceGroupId"`
	PageSize         requests.Integer                 `position:"Query" name:"PageSize"`
	Tag              *[]DescribeDcdnIpaUserDomainsTag `position:"Query" name:"Tag"  type:"Repeated"`
	FuncFilter       string                           `position:"Query" name:"FuncFilter"`
	DomainName       string                           `position:"Query" name:"DomainName"`
	OwnerId          requests.Integer                 `position:"Query" name:"OwnerId"`
	FuncId           string                           `position:"Query" name:"FuncId"`
	DomainStatus     string                           `position:"Query" name:"DomainStatus"`
	DomainSearchType string                           `position:"Query" name:"DomainSearchType"`
}

// DescribeDcdnIpaUserDomainsTag is a repeated param struct in DescribeDcdnIpaUserDomainsRequest
type DescribeDcdnIpaUserDomainsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeDcdnIpaUserDomainsResponse is the response struct for api DescribeDcdnIpaUserDomains
type DescribeDcdnIpaUserDomainsResponse struct {
	*responses.BaseResponse
	RequestId  string                              `json:"RequestId" xml:"RequestId"`
	PageNumber int64                               `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64                               `json:"PageSize" xml:"PageSize"`
	TotalCount int64                               `json:"TotalCount" xml:"TotalCount"`
	Domains    DomainsInDescribeDcdnIpaUserDomains `json:"Domains" xml:"Domains"`
}

// CreateDescribeDcdnIpaUserDomainsRequest creates a request to invoke DescribeDcdnIpaUserDomains API
func CreateDescribeDcdnIpaUserDomainsRequest() (request *DescribeDcdnIpaUserDomainsRequest) {
	request = &DescribeDcdnIpaUserDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnIpaUserDomains", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnIpaUserDomainsResponse creates a response to parse from DescribeDcdnIpaUserDomains response
func CreateDescribeDcdnIpaUserDomainsResponse() (response *DescribeDcdnIpaUserDomainsResponse) {
	response = &DescribeDcdnIpaUserDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
