package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadStagingRoutineCode invokes the dcdn.UploadStagingRoutineCode API synchronously
func (client *Client) UploadStagingRoutineCode(request *UploadStagingRoutineCodeRequest) (response *UploadStagingRoutineCodeResponse, err error) {
	response = CreateUploadStagingRoutineCodeResponse()
	err = client.DoAction(request, response)
	return
}

// UploadStagingRoutineCodeWithChan invokes the dcdn.UploadStagingRoutineCode API asynchronously
func (client *Client) UploadStagingRoutineCodeWithChan(request *UploadStagingRoutineCodeRequest) (<-chan *UploadStagingRoutineCodeResponse, <-chan error) {
	responseChan := make(chan *UploadStagingRoutineCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadStagingRoutineCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadStagingRoutineCodeWithCallback invokes the dcdn.UploadStagingRoutineCode API asynchronously
func (client *Client) UploadStagingRoutineCodeWithCallback(request *UploadStagingRoutineCodeRequest, callback func(response *UploadStagingRoutineCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadStagingRoutineCodeResponse
		var err error
		defer close(result)
		response, err = client.UploadStagingRoutineCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadStagingRoutineCodeRequest is the request struct for api UploadStagingRoutineCode
type UploadStagingRoutineCodeRequest struct {
	*requests.RpcRequest
	CodeDescription string `position:"Body" name:"CodeDescription"`
	Name            string `position:"Body" name:"Name"`
}

// UploadStagingRoutineCodeResponse is the response struct for api UploadStagingRoutineCode
type UploadStagingRoutineCodeResponse struct {
	*responses.BaseResponse
	Content   map[string]interface{} `json:"Content" xml:"Content"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
}

// CreateUploadStagingRoutineCodeRequest creates a request to invoke UploadStagingRoutineCode API
func CreateUploadStagingRoutineCodeRequest() (request *UploadStagingRoutineCodeRequest) {
	request = &UploadStagingRoutineCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "UploadStagingRoutineCode", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadStagingRoutineCodeResponse creates a response to parse from UploadStagingRoutineCode response
func CreateUploadStagingRoutineCodeResponse() (response *UploadStagingRoutineCodeResponse) {
	response = &UploadStagingRoutineCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
