package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOpEntities invokes the ddoscoo.DescribeOpEntities API synchronously
func (client *Client) DescribeOpEntities(request *DescribeOpEntitiesRequest) (response *DescribeOpEntitiesResponse, err error) {
	response = CreateDescribeOpEntitiesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOpEntitiesWithChan invokes the ddoscoo.DescribeOpEntities API asynchronously
func (client *Client) DescribeOpEntitiesWithChan(request *DescribeOpEntitiesRequest) (<-chan *DescribeOpEntitiesResponse, <-chan error) {
	responseChan := make(chan *DescribeOpEntitiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOpEntities(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOpEntitiesWithCallback invokes the ddoscoo.DescribeOpEntities API asynchronously
func (client *Client) DescribeOpEntitiesWithCallback(request *DescribeOpEntitiesRequest, callback func(response *DescribeOpEntitiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOpEntitiesResponse
		var err error
		defer close(result)
		response, err = client.DescribeOpEntities(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOpEntitiesRequest is the request struct for api DescribeOpEntities
type DescribeOpEntitiesRequest struct {
	*requests.RpcRequest
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	EntityObject    string           `position:"Query" name:"EntityObject"`
	EntityType      requests.Integer `position:"Query" name:"EntityType"`
}

// DescribeOpEntitiesResponse is the response struct for api DescribeOpEntities
type DescribeOpEntitiesResponse struct {
	*responses.BaseResponse
	TotalCount int64      `json:"TotalCount" xml:"TotalCount"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	OpEntities []OpEntity `json:"OpEntities" xml:"OpEntities"`
}

// CreateDescribeOpEntitiesRequest creates a request to invoke DescribeOpEntities API
func CreateDescribeOpEntitiesRequest() (request *DescribeOpEntitiesRequest) {
	request = &DescribeOpEntitiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeOpEntities", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOpEntitiesResponse creates a response to parse from DescribeOpEntities response
func CreateDescribeOpEntitiesResponse() (response *DescribeOpEntitiesResponse) {
	response = &DescribeOpEntitiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
