package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFlowBlockholeStatus invokes the ddospro.DescribeFlowBlockholeStatus API synchronously
// api document: https://help.aliyun.com/api/ddospro/describeflowblockholestatus.html
func (client *Client) DescribeFlowBlockholeStatus(request *DescribeFlowBlockholeStatusRequest) (response *DescribeFlowBlockholeStatusResponse, err error) {
	response = CreateDescribeFlowBlockholeStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFlowBlockholeStatusWithChan invokes the ddospro.DescribeFlowBlockholeStatus API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeflowblockholestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFlowBlockholeStatusWithChan(request *DescribeFlowBlockholeStatusRequest) (<-chan *DescribeFlowBlockholeStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeFlowBlockholeStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFlowBlockholeStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFlowBlockholeStatusWithCallback invokes the ddospro.DescribeFlowBlockholeStatus API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeflowblockholestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFlowBlockholeStatusWithCallback(request *DescribeFlowBlockholeStatusRequest, callback func(response *DescribeFlowBlockholeStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFlowBlockholeStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeFlowBlockholeStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFlowBlockholeStatusRequest is the request struct for api DescribeFlowBlockholeStatus
type DescribeFlowBlockholeStatusRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Vips            *[]string        `position:"Query" name:"Vips"  type:"Repeated"`
}

// DescribeFlowBlockholeStatusResponse is the response struct for api DescribeFlowBlockholeStatus
type DescribeFlowBlockholeStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      []Data `json:"Data" xml:"Data"`
}

// CreateDescribeFlowBlockholeStatusRequest creates a request to invoke DescribeFlowBlockholeStatus API
func CreateDescribeFlowBlockholeStatusRequest() (request *DescribeFlowBlockholeStatusRequest) {
	request = &DescribeFlowBlockholeStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "DescribeFlowBlockholeStatus", "", "")
	return
}

// CreateDescribeFlowBlockholeStatusResponse creates a response to parse from DescribeFlowBlockholeStatus response
func CreateDescribeFlowBlockholeStatusResponse() (response *DescribeFlowBlockholeStatusResponse) {
	response = &DescribeFlowBlockholeStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
