package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAccessGroup invokes the dfs.CreateAccessGroup API synchronously
func (client *Client) CreateAccessGroup(request *CreateAccessGroupRequest) (response *CreateAccessGroupResponse, err error) {
	response = CreateCreateAccessGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAccessGroupWithChan invokes the dfs.CreateAccessGroup API asynchronously
func (client *Client) CreateAccessGroupWithChan(request *CreateAccessGroupRequest) (<-chan *CreateAccessGroupResponse, <-chan error) {
	responseChan := make(chan *CreateAccessGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAccessGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAccessGroupWithCallback invokes the dfs.CreateAccessGroup API asynchronously
func (client *Client) CreateAccessGroupWithCallback(request *CreateAccessGroupRequest, callback func(response *CreateAccessGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAccessGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateAccessGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAccessGroupRequest is the request struct for api CreateAccessGroup
type CreateAccessGroupRequest struct {
	*requests.RpcRequest
	Description     string `position:"Query" name:"Description"`
	NetworkType     string `position:"Query" name:"NetworkType"`
	InputRegionId   string `position:"Query" name:"InputRegionId"`
	AccessGroupName string `position:"Query" name:"AccessGroupName"`
}

// CreateAccessGroupResponse is the response struct for api CreateAccessGroup
type CreateAccessGroupResponse struct {
	*responses.BaseResponse
	AccessGroupId string `json:"AccessGroupId" xml:"AccessGroupId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateAccessGroupRequest creates a request to invoke CreateAccessGroup API
func CreateCreateAccessGroupRequest() (request *CreateAccessGroupRequest) {
	request = &CreateAccessGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "CreateAccessGroup", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAccessGroupResponse creates a response to parse from CreateAccessGroup response
func CreateCreateAccessGroupResponse() (response *CreateAccessGroupResponse) {
	response = &CreateAccessGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
