package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSensitiveDataAuditLog invokes the dms_enterprise.ListSensitiveDataAuditLog API synchronously
func (client *Client) ListSensitiveDataAuditLog(request *ListSensitiveDataAuditLogRequest) (response *ListSensitiveDataAuditLogResponse, err error) {
	response = CreateListSensitiveDataAuditLogResponse()
	err = client.DoAction(request, response)
	return
}

// ListSensitiveDataAuditLogWithChan invokes the dms_enterprise.ListSensitiveDataAuditLog API asynchronously
func (client *Client) ListSensitiveDataAuditLogWithChan(request *ListSensitiveDataAuditLogRequest) (<-chan *ListSensitiveDataAuditLogResponse, <-chan error) {
	responseChan := make(chan *ListSensitiveDataAuditLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSensitiveDataAuditLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSensitiveDataAuditLogWithCallback invokes the dms_enterprise.ListSensitiveDataAuditLog API asynchronously
func (client *Client) ListSensitiveDataAuditLogWithCallback(request *ListSensitiveDataAuditLogRequest, callback func(response *ListSensitiveDataAuditLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSensitiveDataAuditLogResponse
		var err error
		defer close(result)
		response, err = client.ListSensitiveDataAuditLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSensitiveDataAuditLogRequest is the request struct for api ListSensitiveDataAuditLog
type ListSensitiveDataAuditLogRequest struct {
	*requests.RpcRequest
	OpUserName string           `position:"Query" name:"OpUserName"`
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	ModuleName string           `position:"Query" name:"ModuleName"`
	TableName  string           `position:"Query" name:"TableName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	ColumnName string           `position:"Query" name:"ColumnName"`
	DbName     string           `position:"Query" name:"DbName"`
}

// ListSensitiveDataAuditLogResponse is the response struct for api ListSensitiveDataAuditLog
type ListSensitiveDataAuditLogResponse struct {
	*responses.BaseResponse
	RequestId                 string                          `json:"RequestId" xml:"RequestId"`
	TotalCount                int64                           `json:"TotalCount" xml:"TotalCount"`
	ErrorCode                 string                          `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage              string                          `json:"ErrorMessage" xml:"ErrorMessage"`
	Success                   bool                            `json:"Success" xml:"Success"`
	SensitiveDataAuditLogList []SensitiveDataAuditLogListItem `json:"SensitiveDataAuditLogList" xml:"SensitiveDataAuditLogList"`
}

// CreateListSensitiveDataAuditLogRequest creates a request to invoke ListSensitiveDataAuditLog API
func CreateListSensitiveDataAuditLogRequest() (request *ListSensitiveDataAuditLogRequest) {
	request = &ListSensitiveDataAuditLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListSensitiveDataAuditLog", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSensitiveDataAuditLogResponse creates a response to parse from ListSensitiveDataAuditLog response
func CreateListSensitiveDataAuditLogResponse() (response *ListSensitiveDataAuditLogResponse) {
	response = &ListSensitiveDataAuditLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
