package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSensitivityLevel invokes the dms_enterprise.ListSensitivityLevel API synchronously
func (client *Client) ListSensitivityLevel(request *ListSensitivityLevelRequest) (response *ListSensitivityLevelResponse, err error) {
	response = CreateListSensitivityLevelResponse()
	err = client.DoAction(request, response)
	return
}

// ListSensitivityLevelWithChan invokes the dms_enterprise.ListSensitivityLevel API asynchronously
func (client *Client) ListSensitivityLevelWithChan(request *ListSensitivityLevelRequest) (<-chan *ListSensitivityLevelResponse, <-chan error) {
	responseChan := make(chan *ListSensitivityLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSensitivityLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSensitivityLevelWithCallback invokes the dms_enterprise.ListSensitivityLevel API asynchronously
func (client *Client) ListSensitivityLevelWithCallback(request *ListSensitivityLevelRequest, callback func(response *ListSensitivityLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSensitivityLevelResponse
		var err error
		defer close(result)
		response, err = client.ListSensitivityLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSensitivityLevelRequest is the request struct for api ListSensitivityLevel
type ListSensitivityLevelRequest struct {
	*requests.RpcRequest
	Tid          requests.Integer `position:"Query" name:"Tid"`
	TemplateType string           `position:"Query" name:"TemplateType"`
	TemplateId   requests.Integer `position:"Query" name:"TemplateId"`
}

// ListSensitivityLevelResponse is the response struct for api ListSensitivityLevel
type ListSensitivityLevelResponse struct {
	*responses.BaseResponse
	RequestId            string                     `json:"RequestId" xml:"RequestId"`
	Success              bool                       `json:"Success" xml:"Success"`
	ErrorMessage         string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode            string                     `json:"ErrorCode" xml:"ErrorCode"`
	SensitivityLevelList []SensitivityLevelListItem `json:"SensitivityLevelList" xml:"SensitivityLevelList"`
}

// CreateListSensitivityLevelRequest creates a request to invoke ListSensitivityLevel API
func CreateListSensitivityLevelRequest() (request *ListSensitivityLevelRequest) {
	request = &ListSensitivityLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListSensitivityLevel", "dms-enterprise", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListSensitivityLevelResponse creates a response to parse from ListSensitivityLevel response
func CreateListSensitivityLevelResponse() (response *ListSensitivityLevelResponse) {
	response = &ListSensitivityLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
