package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOSSInfoForUploadFile invokes the dysmsapi.GetOSSInfoForUploadFile API synchronously
func (client *Client) GetOSSInfoForUploadFile(request *GetOSSInfoForUploadFileRequest) (response *GetOSSInfoForUploadFileResponse, err error) {
	response = CreateGetOSSInfoForUploadFileResponse()
	err = client.DoAction(request, response)
	return
}

// GetOSSInfoForUploadFileWithChan invokes the dysmsapi.GetOSSInfoForUploadFile API asynchronously
func (client *Client) GetOSSInfoForUploadFileWithChan(request *GetOSSInfoForUploadFileRequest) (<-chan *GetOSSInfoForUploadFileResponse, <-chan error) {
	responseChan := make(chan *GetOSSInfoForUploadFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOSSInfoForUploadFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOSSInfoForUploadFileWithCallback invokes the dysmsapi.GetOSSInfoForUploadFile API asynchronously
func (client *Client) GetOSSInfoForUploadFileWithCallback(request *GetOSSInfoForUploadFileRequest, callback func(response *GetOSSInfoForUploadFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOSSInfoForUploadFileResponse
		var err error
		defer close(result)
		response, err = client.GetOSSInfoForUploadFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOSSInfoForUploadFileRequest is the request struct for api GetOSSInfoForUploadFile
type GetOSSInfoForUploadFileRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ProductCode          string           `position:"Query" name:"ProductCode"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	BizType              string           `position:"Query" name:"BizType"`
}

// GetOSSInfoForUploadFileResponse is the response struct for api GetOSSInfoForUploadFile
type GetOSSInfoForUploadFileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateGetOSSInfoForUploadFileRequest creates a request to invoke GetOSSInfoForUploadFile API
func CreateGetOSSInfoForUploadFileRequest() (request *GetOSSInfoForUploadFileRequest) {
	request = &GetOSSInfoForUploadFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "GetOSSInfoForUploadFile", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetOSSInfoForUploadFileResponse creates a response to parse from GetOSSInfoForUploadFile response
func CreateGetOSSInfoForUploadFileResponse() (response *GetOSSInfoForUploadFileResponse) {
	response = &GetOSSInfoForUploadFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
