package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendBatchSms invokes the dysmsapi.SendBatchSms API synchronously
func (client *Client) SendBatchSms(request *SendBatchSmsRequest) (response *SendBatchSmsResponse, err error) {
	response = CreateSendBatchSmsResponse()
	err = client.DoAction(request, response)
	return
}

// SendBatchSmsWithChan invokes the dysmsapi.SendBatchSms API asynchronously
func (client *Client) SendBatchSmsWithChan(request *SendBatchSmsRequest) (<-chan *SendBatchSmsResponse, <-chan error) {
	responseChan := make(chan *SendBatchSmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendBatchSms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendBatchSmsWithCallback invokes the dysmsapi.SendBatchSms API asynchronously
func (client *Client) SendBatchSmsWithCallback(request *SendBatchSmsRequest, callback func(response *SendBatchSmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendBatchSmsResponse
		var err error
		defer close(result)
		response, err = client.SendBatchSms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendBatchSmsRequest is the request struct for api SendBatchSms
type SendBatchSmsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TemplateParamJson    string           `position:"Body" name:"TemplateParamJson"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmsUpExtendCodeJson  string           `position:"Body" name:"SmsUpExtendCodeJson"`
	OutId                string           `position:"Query" name:"OutId"`
	SignNameJson         string           `position:"Body" name:"SignNameJson"`
	TemplateCode         string           `position:"Query" name:"TemplateCode"`
	PhoneNumberJson      string           `position:"Body" name:"PhoneNumberJson"`
}

// SendBatchSmsResponse is the response struct for api SendBatchSms
type SendBatchSmsResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	BizId     string `json:"BizId" xml:"BizId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSendBatchSmsRequest creates a request to invoke SendBatchSms API
func CreateSendBatchSmsRequest() (request *SendBatchSmsRequest) {
	request = &SendBatchSmsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "SendBatchSms", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendBatchSmsResponse creates a response to parse from SendBatchSms response
func CreateSendBatchSmsResponse() (response *SendBatchSmsResponse) {
	response = &SendBatchSmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
