package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SmsConversion invokes the dysmsapi.SmsConversion API synchronously
func (client *Client) SmsConversion(request *SmsConversionRequest) (response *SmsConversionResponse, err error) {
	response = CreateSmsConversionResponse()
	err = client.DoAction(request, response)
	return
}

// SmsConversionWithChan invokes the dysmsapi.SmsConversion API asynchronously
func (client *Client) SmsConversionWithChan(request *SmsConversionRequest) (<-chan *SmsConversionResponse, <-chan error) {
	responseChan := make(chan *SmsConversionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SmsConversion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SmsConversionWithCallback invokes the dysmsapi.SmsConversion API asynchronously
func (client *Client) SmsConversionWithCallback(request *SmsConversionRequest, callback func(response *SmsConversionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SmsConversionResponse
		var err error
		defer close(result)
		response, err = client.SmsConversion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SmsConversionRequest is the request struct for api SmsConversion
type SmsConversionRequest struct {
	*requests.RpcRequest
	ConversionTime requests.Integer `position:"Query" name:"ConversionTime"`
	MessageId      string           `position:"Query" name:"MessageId"`
	Delivered      requests.Boolean `position:"Query" name:"Delivered"`
	To             string           `position:"Query" name:"To"`
}

// SmsConversionResponse is the response struct for api SmsConversion
type SmsConversionResponse struct {
	*responses.BaseResponse
	ResponseCode        string `json:"ResponseCode" xml:"ResponseCode"`
	ResponseDescription string `json:"ResponseDescription" xml:"ResponseDescription"`
	RequestId           string `json:"RequestId" xml:"RequestId"`
}

// CreateSmsConversionRequest creates a request to invoke SmsConversion API
func CreateSmsConversionRequest() (request *SmsConversionRequest) {
	request = &SmsConversionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2018-05-01", "SmsConversion", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSmsConversionResponse creates a response to parse from SmsConversion response
func CreateSmsConversionResponse() (response *SmsConversionResponse) {
	response = &SmsConversionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
