package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeModificationPrice invokes the ecd.DescribeModificationPrice API synchronously
func (client *Client) DescribeModificationPrice(request *DescribeModificationPriceRequest) (response *DescribeModificationPriceResponse, err error) {
	response = CreateDescribeModificationPriceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeModificationPriceWithChan invokes the ecd.DescribeModificationPrice API asynchronously
func (client *Client) DescribeModificationPriceWithChan(request *DescribeModificationPriceRequest) (<-chan *DescribeModificationPriceResponse, <-chan error) {
	responseChan := make(chan *DescribeModificationPriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeModificationPrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeModificationPriceWithCallback invokes the ecd.DescribeModificationPrice API asynchronously
func (client *Client) DescribeModificationPriceWithCallback(request *DescribeModificationPriceRequest, callback func(response *DescribeModificationPriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeModificationPriceResponse
		var err error
		defer close(result)
		response, err = client.DescribeModificationPrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeModificationPriceRequest is the request struct for api DescribeModificationPrice
type DescribeModificationPriceRequest struct {
	*requests.RpcRequest
	RootDiskPerformanceLevel string                                    `position:"Query" name:"RootDiskPerformanceLevel"`
	GroupDesktopCount        requests.Integer                          `position:"Query" name:"GroupDesktopCount"`
	UserDiskPerformanceLevel string                                    `position:"Query" name:"UserDiskPerformanceLevel"`
	InstanceType             string                                    `position:"Query" name:"InstanceType"`
	Bandwidth                requests.Integer                          `position:"Query" name:"Bandwidth"`
	ResourceType             string                                    `position:"Query" name:"ResourceType"`
	PromotionId              string                                    `position:"Query" name:"PromotionId"`
	UserDiskSizeGib          requests.Integer                          `position:"Query" name:"UserDiskSizeGib"`
	ResourceSpecs            *[]DescribeModificationPriceResourceSpecs `position:"Query" name:"ResourceSpecs"  type:"Repeated"`
	InstanceId               string                                    `position:"Query" name:"InstanceId"`
	RootDiskSizeGib          requests.Integer                          `position:"Query" name:"RootDiskSizeGib"`
}

// DescribeModificationPriceResourceSpecs is a repeated param struct in DescribeModificationPriceRequest
type DescribeModificationPriceResourceSpecs struct {
	UserDiskSizeGib string `name:"UserDiskSizeGib"`
	DesktopId       string `name:"DesktopId"`
	RootDiskSizeGib string `name:"RootDiskSizeGib"`
}

// DescribeModificationPriceResponse is the response struct for api DescribeModificationPrice
type DescribeModificationPriceResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	PriceInfo PriceInfo `json:"PriceInfo" xml:"PriceInfo"`
}

// CreateDescribeModificationPriceRequest creates a request to invoke DescribeModificationPrice API
func CreateDescribeModificationPriceRequest() (request *DescribeModificationPriceRequest) {
	request = &DescribeModificationPriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeModificationPrice", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeModificationPriceResponse creates a response to parse from DescribeModificationPrice response
func CreateDescribeModificationPriceResponse() (response *DescribeModificationPriceResponse) {
	response = &DescribeModificationPriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
