package ecs_workbench

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstanceRecords invokes the ecs_workbench.ListInstanceRecords API synchronously
func (client *Client) ListInstanceRecords(request *ListInstanceRecordsRequest) (response *ListInstanceRecordsResponse, err error) {
	response = CreateListInstanceRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceRecordsWithChan invokes the ecs_workbench.ListInstanceRecords API asynchronously
func (client *Client) ListInstanceRecordsWithChan(request *ListInstanceRecordsRequest) (<-chan *ListInstanceRecordsResponse, <-chan error) {
	responseChan := make(chan *ListInstanceRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstanceRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceRecordsWithCallback invokes the ecs_workbench.ListInstanceRecords API asynchronously
func (client *Client) ListInstanceRecordsWithCallback(request *ListInstanceRecordsRequest, callback func(response *ListInstanceRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListInstanceRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceRecordsRequest is the request struct for api ListInstanceRecords
type ListInstanceRecordsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	InstanceId string           `position:"Body" name:"InstanceId"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// ListInstanceRecordsResponse is the response struct for api ListInstanceRecords
type ListInstanceRecordsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Root      Root   `json:"Root" xml:"Root"`
}

// CreateListInstanceRecordsRequest creates a request to invoke ListInstanceRecords API
func CreateListInstanceRecordsRequest() (request *ListInstanceRecordsRequest) {
	request = &ListInstanceRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecs-workbench", "2022-02-20", "ListInstanceRecords", "ecs-workbench", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListInstanceRecordsResponse creates a response to parse from ListInstanceRecords response
func CreateListInstanceRecordsResponse() (response *ListInstanceRecordsResponse) {
	response = &ListInstanceRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
