package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeReservedInstanceAutoRenewAttribute invokes the ecs.DescribeReservedInstanceAutoRenewAttribute API synchronously
func (client *Client) DescribeReservedInstanceAutoRenewAttribute(request *DescribeReservedInstanceAutoRenewAttributeRequest) (response *DescribeReservedInstanceAutoRenewAttributeResponse, err error) {
	response = CreateDescribeReservedInstanceAutoRenewAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeReservedInstanceAutoRenewAttributeWithChan invokes the ecs.DescribeReservedInstanceAutoRenewAttribute API asynchronously
func (client *Client) DescribeReservedInstanceAutoRenewAttributeWithChan(request *DescribeReservedInstanceAutoRenewAttributeRequest) (<-chan *DescribeReservedInstanceAutoRenewAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeReservedInstanceAutoRenewAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeReservedInstanceAutoRenewAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeReservedInstanceAutoRenewAttributeWithCallback invokes the ecs.DescribeReservedInstanceAutoRenewAttribute API asynchronously
func (client *Client) DescribeReservedInstanceAutoRenewAttributeWithCallback(request *DescribeReservedInstanceAutoRenewAttributeRequest, callback func(response *DescribeReservedInstanceAutoRenewAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeReservedInstanceAutoRenewAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeReservedInstanceAutoRenewAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeReservedInstanceAutoRenewAttributeRequest is the request struct for api DescribeReservedInstanceAutoRenewAttribute
type DescribeReservedInstanceAutoRenewAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ReservedInstanceId   *[]string        `position:"Query" name:"ReservedInstanceId"  type:"Repeated"`
}

// DescribeReservedInstanceAutoRenewAttributeResponse is the response struct for api DescribeReservedInstanceAutoRenewAttribute
type DescribeReservedInstanceAutoRenewAttributeResponse struct {
	*responses.BaseResponse
	RequestId                       string                          `json:"RequestId" xml:"RequestId"`
	ReservedInstanceRenewAttributes ReservedInstanceRenewAttributes `json:"ReservedInstanceRenewAttributes" xml:"ReservedInstanceRenewAttributes"`
}

// CreateDescribeReservedInstanceAutoRenewAttributeRequest creates a request to invoke DescribeReservedInstanceAutoRenewAttribute API
func CreateDescribeReservedInstanceAutoRenewAttributeRequest() (request *DescribeReservedInstanceAutoRenewAttributeRequest) {
	request = &DescribeReservedInstanceAutoRenewAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeReservedInstanceAutoRenewAttribute", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeReservedInstanceAutoRenewAttributeResponse creates a response to parse from DescribeReservedInstanceAutoRenewAttribute response
func CreateDescribeReservedInstanceAutoRenewAttributeResponse() (response *DescribeReservedInstanceAutoRenewAttributeResponse) {
	response = &DescribeReservedInstanceAutoRenewAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
