package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyElasticityAssurance invokes the ecs.ModifyElasticityAssurance API synchronously
func (client *Client) ModifyElasticityAssurance(request *ModifyElasticityAssuranceRequest) (response *ModifyElasticityAssuranceResponse, err error) {
	response = CreateModifyElasticityAssuranceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyElasticityAssuranceWithChan invokes the ecs.ModifyElasticityAssurance API asynchronously
func (client *Client) ModifyElasticityAssuranceWithChan(request *ModifyElasticityAssuranceRequest) (<-chan *ModifyElasticityAssuranceResponse, <-chan error) {
	responseChan := make(chan *ModifyElasticityAssuranceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyElasticityAssurance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyElasticityAssuranceWithCallback invokes the ecs.ModifyElasticityAssurance API asynchronously
func (client *Client) ModifyElasticityAssuranceWithCallback(request *ModifyElasticityAssuranceRequest, callback func(response *ModifyElasticityAssuranceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyElasticityAssuranceResponse
		var err error
		defer close(result)
		response, err = client.ModifyElasticityAssurance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyElasticityAssuranceRequest is the request struct for api ModifyElasticityAssurance
type ModifyElasticityAssuranceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                            `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string                                      `position:"Query" name:"ClientToken"`
	Description            string                                      `position:"Query" name:"Description"`
	PrivatePoolOptionsId   string                                      `position:"Query" name:"PrivatePoolOptions.Id"`
	ResourceOwnerAccount   string                                      `position:"Query" name:"ResourceOwnerAccount"`
	PrivatePoolOptionsName string                                      `position:"Query" name:"PrivatePoolOptions.Name"`
	OwnerAccount           string                                      `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer                            `position:"Query" name:"OwnerId"`
	RecurrenceRules        *[]ModifyElasticityAssuranceRecurrenceRules `position:"Query" name:"RecurrenceRules"  type:"Repeated"`
	PackageType            string                                      `position:"Query" name:"PackageType"`
	InstanceAmount         requests.Integer                            `position:"Query" name:"InstanceAmount"`
}

// ModifyElasticityAssuranceRecurrenceRules is a repeated param struct in ModifyElasticityAssuranceRequest
type ModifyElasticityAssuranceRecurrenceRules struct {
	RecurrenceType  string `name:"RecurrenceType"`
	RecurrenceValue string `name:"RecurrenceValue"`
	StartHour       string `name:"StartHour"`
	EndHour         string `name:"EndHour"`
}

// ModifyElasticityAssuranceResponse is the response struct for api ModifyElasticityAssurance
type ModifyElasticityAssuranceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyElasticityAssuranceRequest creates a request to invoke ModifyElasticityAssurance API
func CreateModifyElasticityAssuranceRequest() (request *ModifyElasticityAssuranceRequest) {
	request = &ModifyElasticityAssuranceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyElasticityAssurance", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyElasticityAssuranceResponse creates a response to parse from ModifyElasticityAssurance response
func CreateModifyElasticityAssuranceResponse() (response *ModifyElasticityAssuranceResponse) {
	response = &ModifyElasticityAssuranceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
