package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLniPrivateIpAddress invokes the eflo.ListLniPrivateIpAddress API synchronously
func (client *Client) ListLniPrivateIpAddress(request *ListLniPrivateIpAddressRequest) (response *ListLniPrivateIpAddressResponse, err error) {
	response = CreateListLniPrivateIpAddressResponse()
	err = client.DoAction(request, response)
	return
}

// ListLniPrivateIpAddressWithChan invokes the eflo.ListLniPrivateIpAddress API asynchronously
func (client *Client) ListLniPrivateIpAddressWithChan(request *ListLniPrivateIpAddressRequest) (<-chan *ListLniPrivateIpAddressResponse, <-chan error) {
	responseChan := make(chan *ListLniPrivateIpAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLniPrivateIpAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLniPrivateIpAddressWithCallback invokes the eflo.ListLniPrivateIpAddress API asynchronously
func (client *Client) ListLniPrivateIpAddressWithCallback(request *ListLniPrivateIpAddressRequest, callback func(response *ListLniPrivateIpAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLniPrivateIpAddressResponse
		var err error
		defer close(result)
		response, err = client.ListLniPrivateIpAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLniPrivateIpAddressRequest is the request struct for api ListLniPrivateIpAddress
type ListLniPrivateIpAddressRequest struct {
	*requests.RpcRequest
	Description        string           `position:"Body" name:"Description"`
	PageNumber         requests.Integer `position:"Body" name:"PageNumber"`
	PageSize           requests.Integer `position:"Body" name:"PageSize"`
	Ip                 string           `position:"Body" name:"Ip"`
	EnablePage         requests.Boolean `position:"Body" name:"EnablePage"`
	IpName             string           `position:"Body" name:"IpName"`
	NetworkInterfaceId string           `position:"Body" name:"NetworkInterfaceId"`
}

// ListLniPrivateIpAddressResponse is the response struct for api ListLniPrivateIpAddress
type ListLniPrivateIpAddressResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListLniPrivateIpAddressRequest creates a request to invoke ListLniPrivateIpAddress API
func CreateListLniPrivateIpAddressRequest() (request *ListLniPrivateIpAddressRequest) {
	request = &ListLniPrivateIpAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListLniPrivateIpAddress", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLniPrivateIpAddressResponse creates a response to parse from ListLniPrivateIpAddress response
func CreateListLniPrivateIpAddressResponse() (response *ListLniPrivateIpAddressResponse) {
	response = &ListLniPrivateIpAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
