package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBandwidthPackage invokes the ga.UpdateBandwidthPackage API synchronously
func (client *Client) UpdateBandwidthPackage(request *UpdateBandwidthPackageRequest) (response *UpdateBandwidthPackageResponse, err error) {
	response = CreateUpdateBandwidthPackageResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBandwidthPackageWithChan invokes the ga.UpdateBandwidthPackage API asynchronously
func (client *Client) UpdateBandwidthPackageWithChan(request *UpdateBandwidthPackageRequest) (<-chan *UpdateBandwidthPackageResponse, <-chan error) {
	responseChan := make(chan *UpdateBandwidthPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBandwidthPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBandwidthPackageWithCallback invokes the ga.UpdateBandwidthPackage API asynchronously
func (client *Client) UpdateBandwidthPackageWithCallback(request *UpdateBandwidthPackageRequest, callback func(response *UpdateBandwidthPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBandwidthPackageResponse
		var err error
		defer close(result)
		response, err = client.UpdateBandwidthPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBandwidthPackageRequest is the request struct for api UpdateBandwidthPackage
type UpdateBandwidthPackageRequest struct {
	*requests.RpcRequest
	BandwidthType      string           `position:"Query" name:"BandwidthType"`
	BandwidthPackageId string           `position:"Query" name:"BandwidthPackageId"`
	AutoPay            requests.Boolean `position:"Query" name:"AutoPay"`
	PromotionOptionNo  string           `position:"Query" name:"PromotionOptionNo"`
	Bandwidth          requests.Integer `position:"Query" name:"Bandwidth"`
	Description        string           `position:"Query" name:"Description"`
	AutoUseCoupon      requests.Boolean `position:"Query" name:"AutoUseCoupon"`
	Name               string           `position:"Query" name:"Name"`
}

// UpdateBandwidthPackageResponse is the response struct for api UpdateBandwidthPackage
type UpdateBandwidthPackageResponse struct {
	*responses.BaseResponse
	BandwidthPackage string `json:"BandwidthPackage" xml:"BandwidthPackage"`
	Description      string `json:"Description" xml:"Description"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
	Name             string `json:"Name" xml:"Name"`
}

// CreateUpdateBandwidthPackageRequest creates a request to invoke UpdateBandwidthPackage API
func CreateUpdateBandwidthPackageRequest() (request *UpdateBandwidthPackageRequest) {
	request = &UpdateBandwidthPackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "UpdateBandwidthPackage", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateBandwidthPackageResponse creates a response to parse from UpdateBandwidthPackage response
func CreateUpdateBandwidthPackageResponse() (response *UpdateBandwidthPackageResponse) {
	response = &UpdateBandwidthPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
