package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VoiceIdentityUnregister invokes the green.VoiceIdentityUnregister API synchronously
func (client *Client) VoiceIdentityUnregister(request *VoiceIdentityUnregisterRequest) (response *VoiceIdentityUnregisterResponse, err error) {
	response = CreateVoiceIdentityUnregisterResponse()
	err = client.DoAction(request, response)
	return
}

// VoiceIdentityUnregisterWithChan invokes the green.VoiceIdentityUnregister API asynchronously
func (client *Client) VoiceIdentityUnregisterWithChan(request *VoiceIdentityUnregisterRequest) (<-chan *VoiceIdentityUnregisterResponse, <-chan error) {
	responseChan := make(chan *VoiceIdentityUnregisterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VoiceIdentityUnregister(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VoiceIdentityUnregisterWithCallback invokes the green.VoiceIdentityUnregister API asynchronously
func (client *Client) VoiceIdentityUnregisterWithCallback(request *VoiceIdentityUnregisterRequest, callback func(response *VoiceIdentityUnregisterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VoiceIdentityUnregisterResponse
		var err error
		defer close(result)
		response, err = client.VoiceIdentityUnregister(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VoiceIdentityUnregisterRequest is the request struct for api VoiceIdentityUnregister
type VoiceIdentityUnregisterRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VoiceIdentityUnregisterResponse is the response struct for api VoiceIdentityUnregister
type VoiceIdentityUnregisterResponse struct {
	*responses.BaseResponse
}

// CreateVoiceIdentityUnregisterRequest creates a request to invoke VoiceIdentityUnregister API
func CreateVoiceIdentityUnregisterRequest() (request *VoiceIdentityUnregisterRequest) {
	request = &VoiceIdentityUnregisterRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VoiceIdentityUnregister", "/green/voice/auth/unregister", "", "")
	request.Method = requests.POST
	return
}

// CreateVoiceIdentityUnregisterResponse creates a response to parse from VoiceIdentityUnregister response
func CreateVoiceIdentityUnregisterResponse() (response *VoiceIdentityUnregisterResponse) {
	response = &VoiceIdentityUnregisterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
