package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetUserSsoSettings invokes the ims.SetUserSsoSettings API synchronously
func (client *Client) SetUserSsoSettings(request *SetUserSsoSettingsRequest) (response *SetUserSsoSettingsResponse, err error) {
	response = CreateSetUserSsoSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// SetUserSsoSettingsWithChan invokes the ims.SetUserSsoSettings API asynchronously
func (client *Client) SetUserSsoSettingsWithChan(request *SetUserSsoSettingsRequest) (<-chan *SetUserSsoSettingsResponse, <-chan error) {
	responseChan := make(chan *SetUserSsoSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetUserSsoSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetUserSsoSettingsWithCallback invokes the ims.SetUserSsoSettings API asynchronously
func (client *Client) SetUserSsoSettingsWithCallback(request *SetUserSsoSettingsRequest, callback func(response *SetUserSsoSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetUserSsoSettingsResponse
		var err error
		defer close(result)
		response, err = client.SetUserSsoSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetUserSsoSettingsRequest is the request struct for api SetUserSsoSettings
type SetUserSsoSettingsRequest struct {
	*requests.RpcRequest
	AkProxySuffix    string           `position:"Query" name:"AkProxySuffix"`
	AuxiliaryDomain  string           `position:"Query" name:"AuxiliaryDomain"`
	MetadataDocument string           `position:"Query" name:"MetadataDocument"`
	Reserved         requests.Boolean `position:"Query" name:"Reserved"`
	SsoEnabled       requests.Boolean `position:"Query" name:"SsoEnabled"`
}

// SetUserSsoSettingsResponse is the response struct for api SetUserSsoSettings
type SetUserSsoSettingsResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	UserSsoSettings UserSsoSettings `json:"UserSsoSettings" xml:"UserSsoSettings"`
}

// CreateSetUserSsoSettingsRequest creates a request to invoke SetUserSsoSettings API
func CreateSetUserSsoSettingsRequest() (request *SetUserSsoSettingsRequest) {
	request = &SetUserSsoSettingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "SetUserSsoSettings", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetUserSsoSettingsResponse creates a response to parse from SetUserSsoSettings response
func CreateSetUserSsoSettingsResponse() (response *SetUserSsoSettingsResponse) {
	response = &SetUserSsoSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
