package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeTransferPacketsDownloadUrl invokes the linkwan.GetNodeTransferPacketsDownloadUrl API synchronously
func (client *Client) GetNodeTransferPacketsDownloadUrl(request *GetNodeTransferPacketsDownloadUrlRequest) (response *GetNodeTransferPacketsDownloadUrlResponse, err error) {
	response = CreateGetNodeTransferPacketsDownloadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeTransferPacketsDownloadUrlWithChan invokes the linkwan.GetNodeTransferPacketsDownloadUrl API asynchronously
func (client *Client) GetNodeTransferPacketsDownloadUrlWithChan(request *GetNodeTransferPacketsDownloadUrlRequest) (<-chan *GetNodeTransferPacketsDownloadUrlResponse, <-chan error) {
	responseChan := make(chan *GetNodeTransferPacketsDownloadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeTransferPacketsDownloadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeTransferPacketsDownloadUrlWithCallback invokes the linkwan.GetNodeTransferPacketsDownloadUrl API asynchronously
func (client *Client) GetNodeTransferPacketsDownloadUrlWithCallback(request *GetNodeTransferPacketsDownloadUrlRequest, callback func(response *GetNodeTransferPacketsDownloadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeTransferPacketsDownloadUrlResponse
		var err error
		defer close(result)
		response, err = client.GetNodeTransferPacketsDownloadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeTransferPacketsDownloadUrlRequest is the request struct for api GetNodeTransferPacketsDownloadUrl
type GetNodeTransferPacketsDownloadUrlRequest struct {
	*requests.RpcRequest
	EndMillis    requests.Integer `position:"Query" name:"EndMillis"`
	GwEui        string           `position:"Query" name:"GwEui"`
	Ascending    requests.Boolean `position:"Query" name:"Ascending"`
	DevEui       string           `position:"Query" name:"DevEui"`
	ApiProduct   string           `position:"Body" name:"ApiProduct"`
	ApiRevision  string           `position:"Body" name:"ApiRevision"`
	Category     string           `position:"Query" name:"Category"`
	BeginMillis  requests.Integer `position:"Query" name:"BeginMillis"`
	SortingField string           `position:"Query" name:"SortingField"`
}

// GetNodeTransferPacketsDownloadUrlResponse is the response struct for api GetNodeTransferPacketsDownloadUrl
type GetNodeTransferPacketsDownloadUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetNodeTransferPacketsDownloadUrlRequest creates a request to invoke GetNodeTransferPacketsDownloadUrl API
func CreateGetNodeTransferPacketsDownloadUrlRequest() (request *GetNodeTransferPacketsDownloadUrlRequest) {
	request = &GetNodeTransferPacketsDownloadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetNodeTransferPacketsDownloadUrl", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNodeTransferPacketsDownloadUrlResponse creates a response to parse from GetNodeTransferPacketsDownloadUrl response
func CreateGetNodeTransferPacketsDownloadUrlResponse() (response *GetNodeTransferPacketsDownloadUrlResponse) {
	response = &GetNodeTransferPacketsDownloadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
