package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGateway invokes the linkwan.UpdateGateway API synchronously
func (client *Client) UpdateGateway(request *UpdateGatewayRequest) (response *UpdateGatewayResponse, err error) {
	response = CreateUpdateGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayWithChan invokes the linkwan.UpdateGateway API asynchronously
func (client *Client) UpdateGatewayWithChan(request *UpdateGatewayRequest) (<-chan *UpdateGatewayResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayWithCallback invokes the linkwan.UpdateGateway API asynchronously
func (client *Client) UpdateGatewayWithCallback(request *UpdateGatewayRequest, callback func(response *UpdateGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayResponse
		var err error
		defer close(result)
		response, err = client.UpdateGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayRequest is the request struct for api UpdateGateway
type UpdateGatewayRequest struct {
	*requests.RpcRequest
	City                string           `position:"Query" name:"City"`
	Latitude            requests.Float   `position:"Query" name:"Latitude"`
	Description         string           `position:"Query" name:"Description"`
	AddressCode         requests.Integer `position:"Query" name:"AddressCode"`
	GisCoordinateSystem string           `position:"Query" name:"GisCoordinateSystem"`
	IotInstanceId       string           `position:"Query" name:"IotInstanceId"`
	Longitude           requests.Float   `position:"Query" name:"Longitude"`
	Address             string           `position:"Query" name:"Address"`
	GwEui               string           `position:"Query" name:"GwEui"`
	FreqBandPlanGroupId requests.Integer `position:"Query" name:"FreqBandPlanGroupId"`
	District            string           `position:"Query" name:"District"`
	ApiProduct          string           `position:"Body" name:"ApiProduct"`
	Name                string           `position:"Query" name:"Name"`
	ApiRevision         string           `position:"Body" name:"ApiRevision"`
	CommunicationMode   string           `position:"Query" name:"CommunicationMode"`
}

// UpdateGatewayResponse is the response struct for api UpdateGateway
type UpdateGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateGatewayRequest creates a request to invoke UpdateGateway API
func CreateUpdateGatewayRequest() (request *UpdateGatewayRequest) {
	request = &UpdateGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "UpdateGateway", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayResponse creates a response to parse from UpdateGateway response
func CreateUpdateGatewayResponse() (response *UpdateGatewayResponse) {
	response = &UpdateGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
