package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainTranscodeParams invokes the live.DescribeLiveDomainTranscodeParams API synchronously
func (client *Client) DescribeLiveDomainTranscodeParams(request *DescribeLiveDomainTranscodeParamsRequest) (response *DescribeLiveDomainTranscodeParamsResponse, err error) {
	response = CreateDescribeLiveDomainTranscodeParamsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainTranscodeParamsWithChan invokes the live.DescribeLiveDomainTranscodeParams API asynchronously
func (client *Client) DescribeLiveDomainTranscodeParamsWithChan(request *DescribeLiveDomainTranscodeParamsRequest) (<-chan *DescribeLiveDomainTranscodeParamsResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainTranscodeParamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainTranscodeParams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainTranscodeParamsWithCallback invokes the live.DescribeLiveDomainTranscodeParams API asynchronously
func (client *Client) DescribeLiveDomainTranscodeParamsWithCallback(request *DescribeLiveDomainTranscodeParamsRequest, callback func(response *DescribeLiveDomainTranscodeParamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainTranscodeParamsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainTranscodeParams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainTranscodeParamsRequest is the request struct for api DescribeLiveDomainTranscodeParams
type DescribeLiveDomainTranscodeParamsRequest struct {
	*requests.RpcRequest
	Pushdomain    string `position:"Query" name:"pushdomain"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	App           string `position:"Query" name:"app"`
	TemplateName  string `position:"Query" name:"template_name"`
}

// DescribeLiveDomainTranscodeParamsResponse is the response struct for api DescribeLiveDomainTranscodeParams
type DescribeLiveDomainTranscodeParamsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeLiveDomainTranscodeParamsRequest creates a request to invoke DescribeLiveDomainTranscodeParams API
func CreateDescribeLiveDomainTranscodeParamsRequest() (request *DescribeLiveDomainTranscodeParamsRequest) {
	request = &DescribeLiveDomainTranscodeParamsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainTranscodeParams", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainTranscodeParamsResponse creates a response to parse from DescribeLiveDomainTranscodeParams response
func CreateDescribeLiveDomainTranscodeParamsResponse() (response *DescribeLiveDomainTranscodeParamsResponse) {
	response = &DescribeLiveDomainTranscodeParamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
