package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JoinMessageGroup invokes the live.JoinMessageGroup API synchronously
func (client *Client) JoinMessageGroup(request *JoinMessageGroupRequest) (response *JoinMessageGroupResponse, err error) {
	response = CreateJoinMessageGroupResponse()
	err = client.DoAction(request, response)
	return
}

// JoinMessageGroupWithChan invokes the live.JoinMessageGroup API asynchronously
func (client *Client) JoinMessageGroupWithChan(request *JoinMessageGroupRequest) (<-chan *JoinMessageGroupResponse, <-chan error) {
	responseChan := make(chan *JoinMessageGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JoinMessageGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JoinMessageGroupWithCallback invokes the live.JoinMessageGroup API asynchronously
func (client *Client) JoinMessageGroupWithCallback(request *JoinMessageGroupRequest, callback func(response *JoinMessageGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JoinMessageGroupResponse
		var err error
		defer close(result)
		response, err = client.JoinMessageGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JoinMessageGroupRequest is the request struct for api JoinMessageGroup
type JoinMessageGroupRequest struct {
	*requests.RpcRequest
	UserId              string           `position:"Body" name:"UserId"`
	BroadCastType       requests.Integer `position:"Body" name:"BroadCastType"`
	BroadCastStatistics requests.Boolean `position:"Body" name:"BroadCastStatistics"`
	GroupId             string           `position:"Body" name:"GroupId"`
	AppId               string           `position:"Body" name:"AppId"`
}

// JoinMessageGroupResponse is the response struct for api JoinMessageGroup
type JoinMessageGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateJoinMessageGroupRequest creates a request to invoke JoinMessageGroup API
func CreateJoinMessageGroupRequest() (request *JoinMessageGroupRequest) {
	request = &JoinMessageGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "JoinMessageGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateJoinMessageGroupResponse creates a response to parse from JoinMessageGroup response
func CreateJoinMessageGroupResponse() (response *JoinMessageGroupResponse) {
	response = &JoinMessageGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
