package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCasterResourceGroup invokes the live.UpdateCasterResourceGroup API synchronously
func (client *Client) UpdateCasterResourceGroup(request *UpdateCasterResourceGroupRequest) (response *UpdateCasterResourceGroupResponse, err error) {
	response = CreateUpdateCasterResourceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCasterResourceGroupWithChan invokes the live.UpdateCasterResourceGroup API asynchronously
func (client *Client) UpdateCasterResourceGroupWithChan(request *UpdateCasterResourceGroupRequest) (<-chan *UpdateCasterResourceGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateCasterResourceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCasterResourceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCasterResourceGroupWithCallback invokes the live.UpdateCasterResourceGroup API asynchronously
func (client *Client) UpdateCasterResourceGroupWithCallback(request *UpdateCasterResourceGroupRequest, callback func(response *UpdateCasterResourceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCasterResourceGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateCasterResourceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCasterResourceGroupRequest is the request struct for api UpdateCasterResourceGroup
type UpdateCasterResourceGroupRequest struct {
	*requests.RpcRequest
	CasterId           string           `position:"Query" name:"CasterId"`
	OwnerId            requests.Integer `position:"Query" name:"OwnerId"`
	NewResourceGroupId string           `position:"Query" name:"NewResourceGroupId"`
}

// UpdateCasterResourceGroupResponse is the response struct for api UpdateCasterResourceGroup
type UpdateCasterResourceGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateCasterResourceGroupRequest creates a request to invoke UpdateCasterResourceGroup API
func CreateUpdateCasterResourceGroupRequest() (request *UpdateCasterResourceGroupRequest) {
	request = &UpdateCasterResourceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateCasterResourceGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateCasterResourceGroupResponse creates a response to parse from UpdateCasterResourceGroup response
func CreateUpdateCasterResourceGroupResponse() (response *UpdateCasterResourceGroupResponse) {
	response = &UpdateCasterResourceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
