package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveStreamWatermark invokes the live.UpdateLiveStreamWatermark API synchronously
func (client *Client) UpdateLiveStreamWatermark(request *UpdateLiveStreamWatermarkRequest) (response *UpdateLiveStreamWatermarkResponse, err error) {
	response = CreateUpdateLiveStreamWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveStreamWatermarkWithChan invokes the live.UpdateLiveStreamWatermark API asynchronously
func (client *Client) UpdateLiveStreamWatermarkWithChan(request *UpdateLiveStreamWatermarkRequest) (<-chan *UpdateLiveStreamWatermarkResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveStreamWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveStreamWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveStreamWatermarkWithCallback invokes the live.UpdateLiveStreamWatermark API asynchronously
func (client *Client) UpdateLiveStreamWatermarkWithCallback(request *UpdateLiveStreamWatermarkRequest, callback func(response *UpdateLiveStreamWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveStreamWatermarkResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveStreamWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveStreamWatermarkRequest is the request struct for api UpdateLiveStreamWatermark
type UpdateLiveStreamWatermarkRequest struct {
	*requests.RpcRequest
	YOffset      requests.Float   `position:"Query" name:"YOffset"`
	PictureUrl   string           `position:"Query" name:"PictureUrl"`
	Description  string           `position:"Query" name:"Description"`
	Height       requests.Integer `position:"Query" name:"Height"`
	XOffset      requests.Float   `position:"Query" name:"XOffset"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId   string           `position:"Query" name:"TemplateId"`
	RefWidth     requests.Integer `position:"Query" name:"RefWidth"`
	Transparency requests.Integer `position:"Query" name:"Transparency"`
	Name         string           `position:"Query" name:"Name"`
	OffsetCorner string           `position:"Query" name:"OffsetCorner"`
	RefHeight    requests.Integer `position:"Query" name:"RefHeight"`
}

// UpdateLiveStreamWatermarkResponse is the response struct for api UpdateLiveStreamWatermark
type UpdateLiveStreamWatermarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveStreamWatermarkRequest creates a request to invoke UpdateLiveStreamWatermark API
func CreateUpdateLiveStreamWatermarkRequest() (request *UpdateLiveStreamWatermarkRequest) {
	request = &UpdateLiveStreamWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveStreamWatermark", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveStreamWatermarkResponse creates a response to parse from UpdateLiveStreamWatermark response
func CreateUpdateLiveStreamWatermarkResponse() (response *UpdateLiveStreamWatermarkResponse) {
	response = &UpdateLiveStreamWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
