package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBaaSAntChainPeer invokes the lto.ListBaaSAntChainPeer API synchronously
func (client *Client) ListBaaSAntChainPeer(request *ListBaaSAntChainPeerRequest) (response *ListBaaSAntChainPeerResponse, err error) {
	response = CreateListBaaSAntChainPeerResponse()
	err = client.DoAction(request, response)
	return
}

// ListBaaSAntChainPeerWithChan invokes the lto.ListBaaSAntChainPeer API asynchronously
func (client *Client) ListBaaSAntChainPeerWithChan(request *ListBaaSAntChainPeerRequest) (<-chan *ListBaaSAntChainPeerResponse, <-chan error) {
	responseChan := make(chan *ListBaaSAntChainPeerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBaaSAntChainPeer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBaaSAntChainPeerWithCallback invokes the lto.ListBaaSAntChainPeer API asynchronously
func (client *Client) ListBaaSAntChainPeerWithCallback(request *ListBaaSAntChainPeerRequest, callback func(response *ListBaaSAntChainPeerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBaaSAntChainPeerResponse
		var err error
		defer close(result)
		response, err = client.ListBaaSAntChainPeer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBaaSAntChainPeerRequest is the request struct for api ListBaaSAntChainPeer
type ListBaaSAntChainPeerRequest struct {
	*requests.RpcRequest
	BaaSAntChainConsortiumId string `position:"Query" name:"BaaSAntChainConsortiumId"`
	BaaSAntChainChainId      string `position:"Query" name:"BaaSAntChainChainId"`
}

// ListBaaSAntChainPeerResponse is the response struct for api ListBaaSAntChainPeer
type ListBaaSAntChainPeerResponse struct {
	*responses.BaseResponse
	Code           string                 `json:"Code" xml:"Code"`
	HttpStatusCode int                    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                 `json:"Message" xml:"Message"`
	RequestId      string                 `json:"RequestId" xml:"RequestId"`
	Success        bool                   `json:"Success" xml:"Success"`
	Data           []BaaSAntChainPeerInfo `json:"Data" xml:"Data"`
}

// CreateListBaaSAntChainPeerRequest creates a request to invoke ListBaaSAntChainPeer API
func CreateListBaaSAntChainPeerRequest() (request *ListBaaSAntChainPeerRequest) {
	request = &ListBaaSAntChainPeerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListBaaSAntChainPeer", "", "")
	request.Method = requests.POST
	return
}

// CreateListBaaSAntChainPeerResponse creates a response to parse from ListBaaSAntChainPeer response
func CreateListBaaSAntChainPeerResponse() (response *ListBaaSAntChainPeerResponse) {
	response = &ListBaaSAntChainPeerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
