package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMdsMiniprogramTask invokes the mpaas.CreateMdsMiniprogramTask API synchronously
func (client *Client) CreateMdsMiniprogramTask(request *CreateMdsMiniprogramTaskRequest) (response *CreateMdsMiniprogramTaskResponse, err error) {
	response = CreateCreateMdsMiniprogramTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMdsMiniprogramTaskWithChan invokes the mpaas.CreateMdsMiniprogramTask API asynchronously
func (client *Client) CreateMdsMiniprogramTaskWithChan(request *CreateMdsMiniprogramTaskRequest) (<-chan *CreateMdsMiniprogramTaskResponse, <-chan error) {
	responseChan := make(chan *CreateMdsMiniprogramTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMdsMiniprogramTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMdsMiniprogramTaskWithCallback invokes the mpaas.CreateMdsMiniprogramTask API asynchronously
func (client *Client) CreateMdsMiniprogramTaskWithCallback(request *CreateMdsMiniprogramTaskRequest, callback func(response *CreateMdsMiniprogramTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMdsMiniprogramTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateMdsMiniprogramTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMdsMiniprogramTaskRequest is the request struct for api CreateMdsMiniprogramTask
type CreateMdsMiniprogramTaskRequest struct {
	*requests.RpcRequest
	PackageId       requests.Integer `position:"Body" name:"PackageId"`
	Memo            string           `position:"Body" name:"Memo"`
	GreyConfigInfo  string           `position:"Body" name:"GreyConfigInfo"`
	TenantId        string           `position:"Body" name:"TenantId"`
	PublishMode     string           `position:"Body" name:"PublishMode"`
	Id              requests.Integer `position:"Body" name:"Id"`
	WhitelistIds    string           `position:"Body" name:"WhitelistIds"`
	PublishType     requests.Integer `position:"Body" name:"PublishType"`
	SyncMode        string           `position:"Body" name:"SyncMode"`
	GreyNum         string           `position:"Body" name:"GreyNum"`
	AppId           string           `position:"Body" name:"AppId"`
	GreyEndtimeData string           `position:"Body" name:"GreyEndtimeData"`
	WorkspaceId     string           `position:"Body" name:"WorkspaceId"`
}

// CreateMdsMiniprogramTaskResponse is the response struct for api CreateMdsMiniprogramTask
type CreateMdsMiniprogramTaskResponse struct {
	*responses.BaseResponse
	ResultMessage string        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContent `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMdsMiniprogramTaskRequest creates a request to invoke CreateMdsMiniprogramTask API
func CreateCreateMdsMiniprogramTaskRequest() (request *CreateMdsMiniprogramTaskRequest) {
	request = &CreateMdsMiniprogramTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMdsMiniprogramTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMdsMiniprogramTaskResponse creates a response to parse from CreateMdsMiniprogramTask response
func CreateCreateMdsMiniprogramTaskResponse() (response *CreateMdsMiniprogramTaskResponse) {
	response = &CreateMdsMiniprogramTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
