package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcubeNebulaResources invokes the mpaas.ListMcubeNebulaResources API synchronously
func (client *Client) ListMcubeNebulaResources(request *ListMcubeNebulaResourcesRequest) (response *ListMcubeNebulaResourcesResponse, err error) {
	response = CreateListMcubeNebulaResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcubeNebulaResourcesWithChan invokes the mpaas.ListMcubeNebulaResources API asynchronously
func (client *Client) ListMcubeNebulaResourcesWithChan(request *ListMcubeNebulaResourcesRequest) (<-chan *ListMcubeNebulaResourcesResponse, <-chan error) {
	responseChan := make(chan *ListMcubeNebulaResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcubeNebulaResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcubeNebulaResourcesWithCallback invokes the mpaas.ListMcubeNebulaResources API asynchronously
func (client *Client) ListMcubeNebulaResourcesWithCallback(request *ListMcubeNebulaResourcesRequest, callback func(response *ListMcubeNebulaResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcubeNebulaResourcesResponse
		var err error
		defer close(result)
		response, err = client.ListMcubeNebulaResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcubeNebulaResourcesRequest is the request struct for api ListMcubeNebulaResources
type ListMcubeNebulaResourcesRequest struct {
	*requests.RpcRequest
	PageNum     requests.Integer `position:"Body" name:"PageNum"`
	H5Id        string           `position:"Body" name:"H5Id"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	TenantId    string           `position:"Body" name:"TenantId"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// ListMcubeNebulaResourcesResponse is the response struct for api ListMcubeNebulaResources
type ListMcubeNebulaResourcesResponse struct {
	*responses.BaseResponse
	ResultMessage                 string                        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                    string                        `json:"ResultCode" xml:"ResultCode"`
	RequestId                     string                        `json:"RequestId" xml:"RequestId"`
	ListMcubeNebulaResourceResult ListMcubeNebulaResourceResult `json:"ListMcubeNebulaResourceResult" xml:"ListMcubeNebulaResourceResult"`
}

// CreateListMcubeNebulaResourcesRequest creates a request to invoke ListMcubeNebulaResources API
func CreateListMcubeNebulaResourcesRequest() (request *ListMcubeNebulaResourcesRequest) {
	request = &ListMcubeNebulaResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcubeNebulaResources", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcubeNebulaResourcesResponse creates a response to parse from ListMcubeNebulaResources response
func CreateListMcubeNebulaResourcesResponse() (response *ListMcubeNebulaResourcesResponse) {
	response = &ListMcubeNebulaResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
