package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindSentinelBlockFallbackDefinition invokes the mse.BindSentinelBlockFallbackDefinition API synchronously
func (client *Client) BindSentinelBlockFallbackDefinition(request *BindSentinelBlockFallbackDefinitionRequest) (response *BindSentinelBlockFallbackDefinitionResponse, err error) {
	response = CreateBindSentinelBlockFallbackDefinitionResponse()
	err = client.DoAction(request, response)
	return
}

// BindSentinelBlockFallbackDefinitionWithChan invokes the mse.BindSentinelBlockFallbackDefinition API asynchronously
func (client *Client) BindSentinelBlockFallbackDefinitionWithChan(request *BindSentinelBlockFallbackDefinitionRequest) (<-chan *BindSentinelBlockFallbackDefinitionResponse, <-chan error) {
	responseChan := make(chan *BindSentinelBlockFallbackDefinitionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindSentinelBlockFallbackDefinition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindSentinelBlockFallbackDefinitionWithCallback invokes the mse.BindSentinelBlockFallbackDefinition API asynchronously
func (client *Client) BindSentinelBlockFallbackDefinitionWithCallback(request *BindSentinelBlockFallbackDefinitionRequest, callback func(response *BindSentinelBlockFallbackDefinitionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindSentinelBlockFallbackDefinitionResponse
		var err error
		defer close(result)
		response, err = client.BindSentinelBlockFallbackDefinition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindSentinelBlockFallbackDefinitionRequest is the request struct for api BindSentinelBlockFallbackDefinition
type BindSentinelBlockFallbackDefinitionRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	TargetType     string           `position:"Query" name:"TargetType"`
	AppName        string           `position:"Query" name:"AppName"`
	Resource       string           `position:"Query" name:"Resource"`
	FallbackId     requests.Integer `position:"Query" name:"FallbackId"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// BindSentinelBlockFallbackDefinitionResponse is the response struct for api BindSentinelBlockFallbackDefinition
type BindSentinelBlockFallbackDefinitionResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           bool   `json:"Data" xml:"Data"`
	Code           int    `json:"Code" xml:"Code"`
	Success        string `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateBindSentinelBlockFallbackDefinitionRequest creates a request to invoke BindSentinelBlockFallbackDefinition API
func CreateBindSentinelBlockFallbackDefinitionRequest() (request *BindSentinelBlockFallbackDefinitionRequest) {
	request = &BindSentinelBlockFallbackDefinitionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "BindSentinelBlockFallbackDefinition", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindSentinelBlockFallbackDefinitionResponse creates a response to parse from BindSentinelBlockFallbackDefinition response
func CreateBindSentinelBlockFallbackDefinitionResponse() (response *BindSentinelBlockFallbackDefinitionResponse) {
	response = &BindSentinelBlockFallbackDefinitionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
