package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayFlowRule invokes the mse.UpdateGatewayFlowRule API synchronously
func (client *Client) UpdateGatewayFlowRule(request *UpdateGatewayFlowRuleRequest) (response *UpdateGatewayFlowRuleResponse, err error) {
	response = CreateUpdateGatewayFlowRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayFlowRuleWithChan invokes the mse.UpdateGatewayFlowRule API asynchronously
func (client *Client) UpdateGatewayFlowRuleWithChan(request *UpdateGatewayFlowRuleRequest) (<-chan *UpdateGatewayFlowRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayFlowRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayFlowRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayFlowRuleWithCallback invokes the mse.UpdateGatewayFlowRule API asynchronously
func (client *Client) UpdateGatewayFlowRuleWithCallback(request *UpdateGatewayFlowRuleRequest, callback func(response *UpdateGatewayFlowRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayFlowRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayFlowRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayFlowRuleRequest is the request struct for api UpdateGatewayFlowRule
type UpdateGatewayFlowRuleRequest struct {
	*requests.RpcRequest
	MseSessionId        string           `position:"Query" name:"MseSessionId"`
	Threshold           requests.Integer `position:"Query" name:"Threshold"`
	BehaviorType        requests.Integer `position:"Query" name:"BehaviorType"`
	Enable              requests.Integer `position:"Query" name:"Enable"`
	Id                  requests.Integer `position:"Query" name:"Id"`
	GatewayId           requests.Integer `position:"Query" name:"GatewayId"`
	ResponseStatusCode  requests.Integer `position:"Query" name:"ResponseStatusCode"`
	RouteId             requests.Integer `position:"Query" name:"RouteId"`
	GatewayUniqueId     string           `position:"Query" name:"GatewayUniqueId"`
	BodyEncoding        requests.Integer `position:"Query" name:"BodyEncoding"`
	ResponseRedirectUrl string           `position:"Query" name:"ResponseRedirectUrl"`
	RouteName           string           `position:"Query" name:"RouteName"`
	AcceptLanguage      string           `position:"Query" name:"AcceptLanguage"`
	ResponseContentBody string           `position:"Query" name:"ResponseContentBody"`
}

// UpdateGatewayFlowRuleResponse is the response struct for api UpdateGatewayFlowRule
type UpdateGatewayFlowRuleResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Data      DataInUpdateGatewayFlowRule `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayFlowRuleRequest creates a request to invoke UpdateGatewayFlowRule API
func CreateUpdateGatewayFlowRuleRequest() (request *UpdateGatewayFlowRuleRequest) {
	request = &UpdateGatewayFlowRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayFlowRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayFlowRuleResponse creates a response to parse from UpdateGatewayFlowRule response
func CreateUpdateGatewayFlowRuleResponse() (response *UpdateGatewayFlowRuleResponse) {
	response = &UpdateGatewayFlowRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
