package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataFlow invokes the nas.CreateDataFlow API synchronously
func (client *Client) CreateDataFlow(request *CreateDataFlowRequest) (response *CreateDataFlowResponse, err error) {
	response = CreateCreateDataFlowResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataFlowWithChan invokes the nas.CreateDataFlow API asynchronously
func (client *Client) CreateDataFlowWithChan(request *CreateDataFlowRequest) (<-chan *CreateDataFlowResponse, <-chan error) {
	responseChan := make(chan *CreateDataFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataFlowWithCallback invokes the nas.CreateDataFlow API asynchronously
func (client *Client) CreateDataFlowWithCallback(request *CreateDataFlowRequest, callback func(response *CreateDataFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataFlowResponse
		var err error
		defer close(result)
		response, err = client.CreateDataFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataFlowRequest is the request struct for api CreateDataFlow
type CreateDataFlowRequest struct {
	*requests.RpcRequest
	AutoRefreshPolicy   string                        `position:"Query" name:"AutoRefreshPolicy"`
	FsetId              string                        `position:"Query" name:"FsetId"`
	ClientToken         string                        `position:"Query" name:"ClientToken"`
	Description         string                        `position:"Query" name:"Description"`
	AutoRefreshs        *[]CreateDataFlowAutoRefreshs `position:"Query" name:"AutoRefreshs"  type:"Repeated"`
	SourceSecurityType  string                        `position:"Query" name:"SourceSecurityType"`
	SourceStorage       string                        `position:"Query" name:"SourceStorage"`
	Throughput          requests.Integer              `position:"Query" name:"Throughput"`
	FileSystemId        string                        `position:"Query" name:"FileSystemId"`
	DryRun              requests.Boolean              `position:"Query" name:"DryRun"`
	AutoRefreshInterval requests.Integer              `position:"Query" name:"AutoRefreshInterval"`
}

// CreateDataFlowAutoRefreshs is a repeated param struct in CreateDataFlowRequest
type CreateDataFlowAutoRefreshs struct {
	RefreshPath string `name:"RefreshPath"`
}

// CreateDataFlowResponse is the response struct for api CreateDataFlow
type CreateDataFlowResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DataFlowId string `json:"DataFlowId" xml:"DataFlowId"`
}

// CreateCreateDataFlowRequest creates a request to invoke CreateDataFlow API
func CreateCreateDataFlowRequest() (request *CreateDataFlowRequest) {
	request = &CreateDataFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "CreateDataFlow", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDataFlowResponse creates a response to parse from CreateDataFlow response
func CreateCreateDataFlowResponse() (response *CreateDataFlowResponse) {
	response = &CreateDataFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
