package netana

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpLocationAndIsp invokes the netana.DescribeIpLocationAndIsp API synchronously
// api document: https://help.aliyun.com/api/netana/describeiplocationandisp.html
func (client *Client) DescribeIpLocationAndIsp(request *DescribeIpLocationAndIspRequest) (response *DescribeIpLocationAndIspResponse, err error) {
	response = CreateDescribeIpLocationAndIspResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpLocationAndIspWithChan invokes the netana.DescribeIpLocationAndIsp API asynchronously
// api document: https://help.aliyun.com/api/netana/describeiplocationandisp.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeIpLocationAndIspWithChan(request *DescribeIpLocationAndIspRequest) (<-chan *DescribeIpLocationAndIspResponse, <-chan error) {
	responseChan := make(chan *DescribeIpLocationAndIspResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpLocationAndIsp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpLocationAndIspWithCallback invokes the netana.DescribeIpLocationAndIsp API asynchronously
// api document: https://help.aliyun.com/api/netana/describeiplocationandisp.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeIpLocationAndIspWithCallback(request *DescribeIpLocationAndIspRequest, callback func(response *DescribeIpLocationAndIspResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpLocationAndIspResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpLocationAndIsp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpLocationAndIspRequest is the request struct for api DescribeIpLocationAndIsp
type DescribeIpLocationAndIspRequest struct {
	*requests.RpcRequest
	IpAddress            string           `position:"Query" name:"IpAddress"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
}

// DescribeIpLocationAndIspResponse is the response struct for api DescribeIpLocationAndIsp
type DescribeIpLocationAndIspResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	IpAddress   string `json:"IpAddress" xml:"IpAddress"`
	Country     string `json:"Country" xml:"Country"`
	City        string `json:"City" xml:"City"`
	ISP         string `json:"ISP" xml:"ISP"`
	CountryCode string `json:"CountryCode" xml:"CountryCode"`
	CityCode    string `json:"CityCode" xml:"CityCode"`
	ISPCode     string `json:"ISPCode" xml:"ISPCode"`
}

// CreateDescribeIpLocationAndIspRequest creates a request to invoke DescribeIpLocationAndIsp API
func CreateDescribeIpLocationAndIspRequest() (request *DescribeIpLocationAndIspRequest) {
	request = &DescribeIpLocationAndIspRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Netana", "2018-10-18", "DescribeIpLocationAndIsp", "Netana", "openAPI")
	return
}

// CreateDescribeIpLocationAndIspResponse creates a response to parse from DescribeIpLocationAndIsp response
func CreateDescribeIpLocationAndIspResponse() (response *DescribeIpLocationAndIspResponse) {
	response = &DescribeIpLocationAndIspResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
