package netana

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNetworkQuotaRequestResult invokes the netana.DescribeNetworkQuotaRequestResult API synchronously
// api document: https://help.aliyun.com/api/netana/describenetworkquotarequestresult.html
func (client *Client) DescribeNetworkQuotaRequestResult(request *DescribeNetworkQuotaRequestResultRequest) (response *DescribeNetworkQuotaRequestResultResponse, err error) {
	response = CreateDescribeNetworkQuotaRequestResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNetworkQuotaRequestResultWithChan invokes the netana.DescribeNetworkQuotaRequestResult API asynchronously
// api document: https://help.aliyun.com/api/netana/describenetworkquotarequestresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNetworkQuotaRequestResultWithChan(request *DescribeNetworkQuotaRequestResultRequest) (<-chan *DescribeNetworkQuotaRequestResultResponse, <-chan error) {
	responseChan := make(chan *DescribeNetworkQuotaRequestResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNetworkQuotaRequestResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNetworkQuotaRequestResultWithCallback invokes the netana.DescribeNetworkQuotaRequestResult API asynchronously
// api document: https://help.aliyun.com/api/netana/describenetworkquotarequestresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNetworkQuotaRequestResultWithCallback(request *DescribeNetworkQuotaRequestResultRequest, callback func(response *DescribeNetworkQuotaRequestResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNetworkQuotaRequestResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeNetworkQuotaRequestResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNetworkQuotaRequestResultRequest is the request struct for api DescribeNetworkQuotaRequestResult
type DescribeNetworkQuotaRequestResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Product              string           `position:"Query" name:"Product"`
	QuotaPublicityName   string           `position:"Query" name:"QuotaPublicityName"`
	QuotaRequestId       string           `position:"Query" name:"QuotaRequestId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PageNo               string           `position:"Query" name:"PageNo"`
	PageSize             string           `position:"Query" name:"PageSize"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
}

// DescribeNetworkQuotaRequestResultResponse is the response struct for api DescribeNetworkQuotaRequestResult
type DescribeNetworkQuotaRequestResultResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	TotalCount    int           `json:"TotalCount" xml:"TotalCount"`
	PageNumber    int           `json:"PageNumber" xml:"PageNumber"`
	PageSize      int           `json:"PageSize" xml:"PageSize"`
	QuotaRequests QuotaRequests `json:"QuotaRequests" xml:"QuotaRequests"`
}

// CreateDescribeNetworkQuotaRequestResultRequest creates a request to invoke DescribeNetworkQuotaRequestResult API
func CreateDescribeNetworkQuotaRequestResultRequest() (request *DescribeNetworkQuotaRequestResultRequest) {
	request = &DescribeNetworkQuotaRequestResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Netana", "2018-10-18", "DescribeNetworkQuotaRequestResult", "Netana", "openAPI")
	return
}

// CreateDescribeNetworkQuotaRequestResultResponse creates a response to parse from DescribeNetworkQuotaRequestResult response
func CreateDescribeNetworkQuotaRequestResultResponse() (response *DescribeNetworkQuotaRequestResultResponse) {
	response = &DescribeNetworkQuotaRequestResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
