package nlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopListener invokes the nlb.StopListener API synchronously
func (client *Client) StopListener(request *StopListenerRequest) (response *StopListenerResponse, err error) {
	response = CreateStopListenerResponse()
	err = client.DoAction(request, response)
	return
}

// StopListenerWithChan invokes the nlb.StopListener API asynchronously
func (client *Client) StopListenerWithChan(request *StopListenerRequest) (<-chan *StopListenerResponse, <-chan error) {
	responseChan := make(chan *StopListenerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopListener(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopListenerWithCallback invokes the nlb.StopListener API asynchronously
func (client *Client) StopListenerWithCallback(request *StopListenerRequest, callback func(response *StopListenerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopListenerResponse
		var err error
		defer close(result)
		response, err = client.StopListener(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopListenerRequest is the request struct for api StopListener
type StopListenerRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Body" name:"ClientToken"`
	ListenerId  string           `position:"Body" name:"ListenerId"`
	DryRun      requests.Boolean `position:"Body" name:"DryRun"`
}

// StopListenerResponse is the response struct for api StopListener
type StopListenerResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	JobId          string `json:"JobId" xml:"JobId"`
}

// CreateStopListenerRequest creates a request to invoke StopListener API
func CreateStopListenerRequest() (request *StopListenerRequest) {
	request = &StopListenerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Nlb", "2022-04-30", "StopListener", "nlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopListenerResponse creates a response to parse from StopListener response
func CreateStopListenerResponse() (response *StopListenerResponse) {
	response = &StopListenerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
